@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.kotlin.outputs.ClusterAvailableUpgradeVersionResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ClusterCapacityResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ManagedResourceGroupConfigurationResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.RackDefinitionResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ServicePrincipalInformationResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ValidationThresholdResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ClusterAvailableUpgradeVersionResponse.Companion.toKotlin as clusterAvailableUpgradeVersionResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ClusterCapacityResponse.Companion.toKotlin as clusterCapacityResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ManagedResourceGroupConfigurationResponse.Companion.toKotlin as managedResourceGroupConfigurationResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.RackDefinitionResponse.Companion.toKotlin as rackDefinitionResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ServicePrincipalInformationResponse.Companion.toKotlin as servicePrincipalInformationResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ValidationThresholdResponse.Companion.toKotlin as validationThresholdResponseToKotlin

/**
 * Builder for [Cluster].
 */
@PulumiTagMarker
public class ClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterArgs = ClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterArgsBuilder.() -> Unit) {
        val builder = ClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Cluster {
        val builtJavaResource = com.pulumi.azurenative.networkcloud.Cluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Cluster(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-12-12-preview.
 * Other available API versions: 2023-07-01, 2023-10-01-preview.
 * ## Example Usage
 * ### Create or update cluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.NetworkCloud.Cluster("cluster", new()
 *     {
 *         AggregatorOrSingleRackDefinition = new AzureNative.NetworkCloud.Inputs.RackDefinitionArgs
 *         {
 *             BareMetalMachineConfigurationData = new[]
 *             {
 *                 new AzureNative.NetworkCloud.Inputs.BareMetalMachineConfigurationDataArgs
 *                 {
 *                     BmcCredentials = new AzureNative.NetworkCloud.Inputs.AdministrativeCredentialsArgs
 *                     {
 *                         Password = "{password}",
 *                         Username = "username",
 *                     },
 *                     BmcMacAddress = "AA:BB:CC:DD:EE:FF",
 *                     BootMacAddress = "00:BB:CC:DD:EE:FF",
 *                     MachineDetails = "extraDetails",
 *                     MachineName = "bmmName1",
 *                     RackSlot = 1,
 *                     SerialNumber = "BM1219XXX",
 *                 },
 *                 new AzureNative.NetworkCloud.Inputs.BareMetalMachineConfigurationDataArgs
 *                 {
 *                     BmcCredentials = new AzureNative.NetworkCloud.Inputs.AdministrativeCredentialsArgs
 *                     {
 *                         Password = "{password}",
 *                         Username = "username",
 *                     },
 *                     BmcMacAddress = "AA:BB:CC:DD:EE:00",
 *                     BootMacAddress = "00:BB:CC:DD:EE:00",
 *                     MachineDetails = "extraDetails",
 *                     MachineName = "bmmName2",
 *                     RackSlot = 2,
 *                     SerialNumber = "BM1219YYY",
 *                 },
 *             },
 *             NetworkRackId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkRacks/networkRackName",
 *             RackLocation = "Foo Datacenter, Floor 3, Aisle 9, Rack 2",
 *             RackSerialNumber = "AA1234",
 *             RackSkuId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/providers/Microsoft.NetworkCloud/rackSkus/rackSkuName",
 *             StorageApplianceConfigurationData = new[]
 *             {
 *                 new AzureNative.NetworkCloud.Inputs.StorageApplianceConfigurationDataArgs
 *                 {
 *                     AdminCredentials = new AzureNative.NetworkCloud.Inputs.AdministrativeCredentialsArgs
 *                     {
 *                         Password = "{password}",
 *                         Username = "username",
 *                     },
 *                     RackSlot = 1,
 *                     SerialNumber = "BM1219XXX",
 *                     StorageApplianceName = "vmName",
 *                 },
 *             },
 *         },
 *         AnalyticsWorkspaceId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/microsoft.operationalInsights/workspaces/logAnalyticsWorkspaceName",
 *         ClusterLocation = "Foo Street, 3rd Floor, row 9",
 *         ClusterName = "clusterName",
 *         ClusterServicePrincipal = new AzureNative.NetworkCloud.Inputs.ServicePrincipalInformationArgs
 *         {
 *             ApplicationId = "12345678-1234-1234-1234-123456789012",
 *             Password = "{password}",
 *             PrincipalId = "00000008-0004-0004-0004-000000000012",
 *             TenantId = "80000000-4000-4000-4000-120000000000",
 *         },
 *         ClusterType = "SingleRack",
 *         ClusterVersion = "1.0.0",
 *         ComputeDeploymentThreshold = new AzureNative.NetworkCloud.Inputs.ValidationThresholdArgs
 *         {
 *             Grouping = "PerCluster",
 *             Type = "PercentSuccess",
 *             Value = 90,
 *         },
 *         ComputeRackDefinitions = new[]
 *         {
 *             new AzureNative.NetworkCloud.Inputs.RackDefinitionArgs
 *             {
 *                 BareMetalMachineConfigurationData = new[]
 *                 {
 *                     new AzureNative.NetworkCloud.Inputs.BareMetalMachineConfigurationDataArgs
 *                     {
 *                         BmcCredentials = new AzureNative.NetworkCloud.Inputs.AdministrativeCredentialsArgs
 *                         {
 *                             Password = "{password}",
 *                             Username = "username",
 *                         },
 *                         BmcMacAddress = "AA:BB:CC:DD:EE:FF",
 *                         BootMacAddress = "00:BB:CC:DD:EE:FF",
 *                         MachineDetails = "extraDetails",
 *                         MachineName = "bmmName1",
 *                         RackSlot = 1,
 *                         SerialNumber = "BM1219XXX",
 *                     },
 *                     new AzureNative.NetworkCloud.Inputs.BareMetalMachineConfigurationDataArgs
 *                     {
 *                         BmcCredentials = new AzureNative.NetworkCloud.Inputs.AdministrativeCredentialsArgs
 *                         {
 *                             Password = "{password}",
 *                             Username = "username",
 *                         },
 *                         BmcMacAddress = "AA:BB:CC:DD:EE:00",
 *                         BootMacAddress = "00:BB:CC:DD:EE:00",
 *                         MachineDetails = "extraDetails",
 *                         MachineName = "bmmName2",
 *                         RackSlot = 2,
 *                         SerialNumber = "BM1219YYY",
 *                     },
 *                 },
 *                 NetworkRackId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkRacks/networkRackName",
 *                 RackLocation = "Foo Datacenter, Floor 3, Aisle 9, Rack 2",
 *                 RackSerialNumber = "AA1234",
 *                 RackSkuId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/providers/Microsoft.NetworkCloud/rackSkus/rackSkuName",
 *                 StorageApplianceConfigurationData = new[]
 *                 {
 *                     new AzureNative.NetworkCloud.Inputs.StorageApplianceConfigurationDataArgs
 *                     {
 *                         AdminCredentials = new AzureNative.NetworkCloud.Inputs.AdministrativeCredentialsArgs
 *                         {
 *                             Password = "{password}",
 *                             Username = "username",
 *                         },
 *                         RackSlot = 1,
 *                         SerialNumber = "BM1219XXX",
 *                         StorageApplianceName = "vmName",
 *                     },
 *                 },
 *             },
 *         },
 *         ExtendedLocation = new AzureNative.NetworkCloud.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterManagerExtendedLocationName",
 *             Type = "CustomLocation",
 *         },
 *         Location = "location",
 *         ManagedResourceGroupConfiguration = new AzureNative.NetworkCloud.Inputs.ManagedResourceGroupConfigurationArgs
 *         {
 *             Location = "East US",
 *             Name = "my-managed-rg",
 *         },
 *         NetworkFabricId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkFabrics/fabricName",
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := networkcloud.NewCluster(ctx, "cluster", &networkcloud.ClusterArgs{
 * AggregatorOrSingleRackDefinition: networkcloud.RackDefinitionResponse{
 * BareMetalMachineConfigurationData: networkcloud.BareMetalMachineConfigurationDataArray{
 * interface{}{
 * BmcCredentials: &networkcloud.AdministrativeCredentialsArgs{
 * Password: pulumi.String("{password}"),
 * Username: pulumi.String("username"),
 * },
 * BmcMacAddress: pulumi.String("AA:BB:CC:DD:EE:FF"),
 * BootMacAddress: pulumi.String("00:BB:CC:DD:EE:FF"),
 * MachineDetails: pulumi.String("extraDetails"),
 * MachineName: pulumi.String("bmmName1"),
 * RackSlot: pulumi.Float64(1),
 * SerialNumber: pulumi.String("BM1219XXX"),
 * },
 * interface{}{
 * BmcCredentials: &networkcloud.AdministrativeCredentialsArgs{
 * Password: pulumi.String("{password}"),
 * Username: pulumi.String("username"),
 * },
 * BmcMacAddress: pulumi.String("AA:BB:CC:DD:EE:00"),
 * BootMacAddress: pulumi.String("00:BB:CC:DD:EE:00"),
 * MachineDetails: pulumi.String("extraDetails"),
 * MachineName: pulumi.String("bmmName2"),
 * RackSlot: pulumi.Float64(2),
 * SerialNumber: pulumi.String("BM1219YYY"),
 * },
 * },
 * NetworkRackId: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkRacks/networkRackName"),
 * RackLocation: pulumi.String("Foo Datacenter, Floor 3, Aisle 9, Rack 2"),
 * RackSerialNumber: pulumi.String("AA1234"),
 * RackSkuId: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/providers/Microsoft.NetworkCloud/rackSkus/rackSkuName"),
 * StorageApplianceConfigurationData: networkcloud.StorageApplianceConfigurationDataArray{
 * interface{}{
 * AdminCredentials: &networkcloud.AdministrativeCredentialsArgs{
 * Password: pulumi.String("{password}"),
 * Username: pulumi.String("username"),
 * },
 * RackSlot: pulumi.Float64(1),
 * SerialNumber: pulumi.String("BM1219XXX"),
 * StorageApplianceName: pulumi.String("vmName"),
 * },
 * },
 * },
 * AnalyticsWorkspaceId: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/microsoft.operationalInsights/workspaces/logAnalyticsWorkspaceName"),
 * ClusterLocation: pulumi.String("Foo Street, 3rd Floor, row 9"),
 * ClusterName: pulumi.String("clusterName"),
 * ClusterServicePrincipal: &networkcloud.ServicePrincipalInformationArgs{
 * ApplicationId: pulumi.String("12345678-1234-1234-1234-123456789012"),
 * Password: pulumi.String("{password}"),
 * PrincipalId: pulumi.String("00000008-0004-0004-0004-000000000012"),
 * TenantId: pulumi.String("80000000-4000-4000-4000-120000000000"),
 * },
 * ClusterType: pulumi.String("SingleRack"),
 * ClusterVersion: pulumi.String("1.0.0"),
 * ComputeDeploymentThreshold: &networkcloud.ValidationThresholdArgs{
 * Grouping: pulumi.String("PerCluster"),
 * Type: pulumi.String("PercentSuccess"),
 * Value: pulumi.Float64(90),
 * },
 * ComputeRackDefinitions: []networkcloud.RackDefinitionArgs{
 * {
 * BareMetalMachineConfigurationData: networkcloud.BareMetalMachineConfigurationDataArray{
 * {
 * BmcCredentials: {
 * Password: pulumi.String("{password}"),
 * Username: pulumi.String("username"),
 * },
 * BmcMacAddress: pulumi.String("AA:BB:CC:DD:EE:FF"),
 * BootMacAddress: pulumi.String("00:BB:CC:DD:EE:FF"),
 * MachineDetails: pulumi.String("extraDetails"),
 * MachineName: pulumi.String("bmmName1"),
 * RackSlot: pulumi.Float64(1),
 * SerialNumber: pulumi.String("BM1219XXX"),
 * },
 * {
 * BmcCredentials: {
 * Password: pulumi.String("{password}"),
 * Username: pulumi.String("username"),
 * },
 * BmcMacAddress: pulumi.String("AA:BB:CC:DD:EE:00"),
 * BootMacAddress: pulumi.String("00:BB:CC:DD:EE:00"),
 * MachineDetails: pulumi.String("extraDetails"),
 * MachineName: pulumi.String("bmmName2"),
 * RackSlot: pulumi.Float64(2),
 * SerialNumber: pulumi.String("BM1219YYY"),
 * },
 * },
 * NetworkRackId: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkRacks/networkRackName"),
 * RackLocation: pulumi.String("Foo Datacenter, Floor 3, Aisle 9, Rack 2"),
 * RackSerialNumber: pulumi.String("AA1234"),
 * RackSkuId: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/providers/Microsoft.NetworkCloud/rackSkus/rackSkuName"),
 * StorageApplianceConfigurationData: networkcloud.StorageApplianceConfigurationDataArray{
 * {
 * AdminCredentials: {
 * Password: pulumi.String("{password}"),
 * Username: pulumi.String("username"),
 * },
 * RackSlot: pulumi.Float64(1),
 * SerialNumber: pulumi.String("BM1219XXX"),
 * StorageApplianceName: pulumi.String("vmName"),
 * },
 * },
 * },
 * },
 * ExtendedLocation: &networkcloud.ExtendedLocationArgs{
 * Name: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterManagerExtendedLocationName"),
 * Type: pulumi.String("CustomLocation"),
 * },
 * Location: pulumi.String("location"),
 * ManagedResourceGroupConfiguration: &networkcloud.ManagedResourceGroupConfigurationArgs{
 * Location: pulumi.String("East US"),
 * Name: pulumi.String("my-managed-rg"),
 * },
 * NetworkFabricId: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkFabrics/fabricName"),
 * ResourceGroupName: pulumi.String("resourceGroupName"),
 * Tags: pulumi.StringMap{
 * "key1": pulumi.String("myvalue1"),
 * "key2": pulumi.String("myvalue2"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.Cluster;
 * import com.pulumi.azurenative.networkcloud.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .aggregatorOrSingleRackDefinition(Map.ofEntries(
 *                 Map.entry("bareMetalMachineConfigurationData",
 *                     Map.ofEntries(
 *                         Map.entry("bmcCredentials", Map.ofEntries(
 *                             Map.entry("password", "{password}"),
 *                             Map.entry("username", "username")
 *                         )),
 *                         Map.entry("bmcMacAddress", "AA:BB:CC:DD:EE:FF"),
 *                         Map.entry("bootMacAddress", "00:BB:CC:DD:EE:FF"),
 *                         Map.entry("machineDetails", "extraDetails"),
 *                         Map.entry("machineName", "bmmName1"),
 *                         Map.entry("rackSlot", 1),
 *                         Map.entry("serialNumber", "BM1219XXX")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("bmcCredentials", Map.ofEntries(
 *                             Map.entry("password", "{password}"),
 *                             Map.entry("username", "username")
 *                         )),
 *                         Map.entry("bmcMacAddress", "AA:BB:CC:DD:EE:00"),
 *                         Map.entry("bootMacAddress", "00:BB:CC:DD:EE:00"),
 *                         Map.entry("machineDetails", "extraDetails"),
 *                         Map.entry("machineName", "bmmName2"),
 *                         Map.entry("rackSlot", 2),
 *                         Map.entry("serialNumber", "BM1219YYY")
 *                     )),
 *                 Map.entry("networkRackId", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkRacks/networkRackName"),
 *                 Map.entry("rackLocation", "Foo Datacenter, Floor 3, Aisle 9, Rack 2"),
 *                 Map.entry("rackSerialNumber", "AA1234"),
 *                 Map.entry("rackSkuId", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/providers/Microsoft.NetworkCloud/rackSkus/rackSkuName"),
 *                 Map.entry("storageApplianceConfigurationData", Map.ofEntries(
 *                     Map.entry("adminCredentials", Map.ofEntries(
 *                         Map.entry("password", "{password}"),
 *                         Map.entry("username", "username")
 *                     )),
 *                     Map.entry("rackSlot", 1),
 *                     Map.entry("serialNumber", "BM1219XXX"),
 *                     Map.entry("storageApplianceName", "vmName")
 *                 ))
 *             ))
 *             .analyticsWorkspaceId("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/microsoft.operationalInsights/workspaces/logAnalyticsWorkspaceName")
 *             .clusterLocation("Foo Street, 3rd Floor, row 9")
 *             .clusterName("clusterName")
 *             .clusterServicePrincipal(Map.ofEntries(
 *                 Map.entry("applicationId", "12345678-1234-1234-1234-123456789012"),
 *                 Map.entry("password", "{password}"),
 *                 Map.entry("principalId", "00000008-0004-0004-0004-000000000012"),
 *                 Map.entry("tenantId", "80000000-4000-4000-4000-120000000000")
 *             ))
 *             .clusterType("SingleRack")
 *             .clusterVersion("1.0.0")
 *             .computeDeploymentThreshold(Map.ofEntries(
 *                 Map.entry("grouping", "PerCluster"),
 *                 Map.entry("type", "PercentSuccess"),
 *                 Map.entry("value", 90)
 *             ))
 *             .computeRackDefinitions(Map.ofEntries(
 *                 Map.entry("bareMetalMachineConfigurationData",
 *                     Map.ofEntries(
 *                         Map.entry("bmcCredentials", Map.ofEntries(
 *                             Map.entry("password", "{password}"),
 *                             Map.entry("username", "username")
 *                         )),
 *                         Map.entry("bmcMacAddress", "AA:BB:CC:DD:EE:FF"),
 *                         Map.entry("bootMacAddress", "00:BB:CC:DD:EE:FF"),
 *                         Map.entry("machineDetails", "extraDetails"),
 *                         Map.entry("machineName", "bmmName1"),
 *                         Map.entry("rackSlot", 1),
 *                         Map.entry("serialNumber", "BM1219XXX")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("bmcCredentials", Map.ofEntries(
 *                             Map.entry("password", "{password}"),
 *                             Map.entry("username", "username")
 *                         )),
 *                         Map.entry("bmcMacAddress", "AA:BB:CC:DD:EE:00"),
 *                         Map.entry("bootMacAddress", "00:BB:CC:DD:EE:00"),
 *                         Map.entry("machineDetails", "extraDetails"),
 *                         Map.entry("machineName", "bmmName2"),
 *                         Map.entry("rackSlot", 2),
 *                         Map.entry("serialNumber", "BM1219YYY")
 *                     )),
 *                 Map.entry("networkRackId", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkRacks/networkRackName"),
 *                 Map.entry("rackLocation", "Foo Datacenter, Floor 3, Aisle 9, Rack 2"),
 *                 Map.entry("rackSerialNumber", "AA1234"),
 *                 Map.entry("rackSkuId", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/providers/Microsoft.NetworkCloud/rackSkus/rackSkuName"),
 *                 Map.entry("storageApplianceConfigurationData", Map.ofEntries(
 *                     Map.entry("adminCredentials", Map.ofEntries(
 *                         Map.entry("password", "{password}"),
 *                         Map.entry("username", "username")
 *                     )),
 *                     Map.entry("rackSlot", 1),
 *                     Map.entry("serialNumber", "BM1219XXX"),
 *                     Map.entry("storageApplianceName", "vmName")
 *                 ))
 *             ))
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterManagerExtendedLocationName"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .location("location")
 *             .managedResourceGroupConfiguration(Map.ofEntries(
 *                 Map.entry("location", "East US"),
 *                 Map.entry("name", "my-managed-rg")
 *             ))
 *             .networkFabricId("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkFabrics/fabricName")
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:Cluster clusterName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/clusters/{clusterName}
 * ```
 */
public class Cluster internal constructor(
    override val javaResource: com.pulumi.azurenative.networkcloud.Cluster,
) : KotlinCustomResource(javaResource, ClusterMapper) {
    /**
     * The rack definition that is intended to reflect only a single rack in a single rack cluster, or an aggregator rack in a multi-rack cluster.
     */
    public val aggregatorOrSingleRackDefinition: Output<RackDefinitionResponse>
        get() = javaResource.aggregatorOrSingleRackDefinition().applyValue({ args0 ->
            args0.let({ args0 ->
                rackDefinitionResponseToKotlin(args0)
            })
        })

    /**
     * The resource ID of the Log Analytics Workspace that will be used for storing relevant logs.
     */
    public val analyticsWorkspaceId: Output<String>?
        get() = javaResource.analyticsWorkspaceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The list of cluster runtime version upgrades available for this cluster.
     */
    public val availableUpgradeVersions: Output<List<ClusterAvailableUpgradeVersionResponse>>
        get() = javaResource.availableUpgradeVersions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> clusterAvailableUpgradeVersionResponseToKotlin(args0) })
            })
        })

    /**
     * The capacity supported by this cluster.
     */
    public val clusterCapacity: Output<ClusterCapacityResponse>
        get() = javaResource.clusterCapacity().applyValue({ args0 ->
            args0.let({ args0 ->
                clusterCapacityResponseToKotlin(args0)
            })
        })

    /**
     * The latest heartbeat status between the cluster manager and the cluster.
     */
    public val clusterConnectionStatus: Output<String>
        get() = javaResource.clusterConnectionStatus().applyValue({ args0 -> args0 })

    /**
     * The extended location (custom location) that represents the cluster's control plane location. This extended location is used to route the requests of child objects of the cluster that are handled by the platform operator.
     */
    public val clusterExtendedLocation: Output<ExtendedLocationResponse>
        get() = javaResource.clusterExtendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationResponseToKotlin(args0)
            })
        })

    /**
     * The customer-provided location information to identify where the cluster resides.
     */
    public val clusterLocation: Output<String>?
        get() = javaResource.clusterLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The latest connectivity status between cluster manager and the cluster.
     */
    public val clusterManagerConnectionStatus: Output<String>
        get() = javaResource.clusterManagerConnectionStatus().applyValue({ args0 -> args0 })

    /**
     * The resource ID of the cluster manager that manages this cluster. This is set by the Cluster Manager when the cluster is created.
     */
    public val clusterManagerId: Output<String>
        get() = javaResource.clusterManagerId().applyValue({ args0 -> args0 })

    /**
     * The service principal to be used by the cluster during Arc Appliance installation.
     */
    public val clusterServicePrincipal: Output<ServicePrincipalInformationResponse>?
        get() = javaResource.clusterServicePrincipal().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> servicePrincipalInformationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The type of rack configuration for the cluster.
     */
    public val clusterType: Output<String>
        get() = javaResource.clusterType().applyValue({ args0 -> args0 })

    /**
     * The current runtime version of the cluster.
     */
    public val clusterVersion: Output<String>
        get() = javaResource.clusterVersion().applyValue({ args0 -> args0 })

    /**
     * The validation threshold indicating the allowable failures of compute machines during environment validation and deployment.
     */
    public val computeDeploymentThreshold: Output<ValidationThresholdResponse>?
        get() = javaResource.computeDeploymentThreshold().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> validationThresholdResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The list of rack definitions for the compute racks in a multi-rack
     * cluster, or an empty list in a single-rack cluster.
     */
    public val computeRackDefinitions: Output<List<RackDefinitionResponse>>?
        get() = javaResource.computeRackDefinitions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        rackDefinitionResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The current detailed status of the cluster.
     */
    public val detailedStatus: Output<String>
        get() = javaResource.detailedStatus().applyValue({ args0 -> args0 })

    /**
     * The descriptive message about the detailed status.
     */
    public val detailedStatusMessage: Output<String>
        get() = javaResource.detailedStatusMessage().applyValue({ args0 -> args0 })

    /**
     * The extended location of the cluster manager associated with the cluster.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationResponseToKotlin(args0)
            })
        })

    /**
     * Field Deprecated. This field will not be populated in an upcoming version. The extended location (custom location) that represents the Hybrid AKS control plane location. This extended location is used when creating provisioned clusters (Hybrid AKS clusters).
     */
    public val hybridAksExtendedLocation: Output<ExtendedLocationResponse>
        get() = javaResource.hybridAksExtendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationResponseToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The configuration of the managed resource group associated with the resource.
     */
    public val managedResourceGroupConfiguration: Output<ManagedResourceGroupConfigurationResponse>?
        get() = javaResource.managedResourceGroupConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedResourceGroupConfigurationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The count of Manual Action Taken (MAT) events that have not been validated.
     */
    public val manualActionCount: Output<Double>
        get() = javaResource.manualActionCount().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The resource ID of the Network Fabric associated with the cluster.
     */
    public val networkFabricId: Output<String>
        get() = javaResource.networkFabricId().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the cluster.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The support end date of the runtime version of the cluster.
     */
    public val supportExpiryDate: Output<String>
        get() = javaResource.supportExpiryDate().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The list of workload resource IDs that are hosted within this cluster.
     */
    public val workloadResourceIds: Output<List<String>>
        get() = javaResource.workloadResourceIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object ClusterMapper : ResourceMapper<Cluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.networkcloud.Cluster::class == javaResource::class

    override fun map(javaResource: Resource): Cluster = Cluster(
        javaResource as
            com.pulumi.azurenative.networkcloud.Cluster,
    )
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Cluster].
 */
public suspend fun cluster(name: String, block: suspend ClusterResourceBuilder.() -> Unit):
    Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cluster(name: String): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
