@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.MetricsConfigurationArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-12-12-preview.
 * Other available API versions: 2023-07-01, 2023-10-01-preview.
 * ## Example Usage
 * ### Create or update metrics configuration of cluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var metricsConfiguration = new AzureNative.NetworkCloud.MetricsConfiguration("metricsConfiguration", new()
 *     {
 *         ClusterName = "clusterName",
 *         CollectionInterval = 15,
 *         EnabledMetrics = new[]
 *         {
 *             "metric1",
 *             "metric2",
 *         },
 *         ExtendedLocation = new AzureNative.NetworkCloud.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName",
 *             Type = "CustomLocation",
 *         },
 *         Location = "location",
 *         MetricsConfigurationName = "default",
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkcloud.NewMetricsConfiguration(ctx, "metricsConfiguration", &networkcloud.MetricsConfigurationArgs{
 * 			ClusterName:        pulumi.String("clusterName"),
 * 			CollectionInterval: pulumi.Float64(15),
 * 			EnabledMetrics: pulumi.StringArray{
 * 				pulumi.String("metric1"),
 * 				pulumi.String("metric2"),
 * 			},
 * 			ExtendedLocation: &networkcloud.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location:                 pulumi.String("location"),
 * 			MetricsConfigurationName: pulumi.String("default"),
 * 			ResourceGroupName:        pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("myvalue1"),
 * 				"key2": pulumi.String("myvalue2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.MetricsConfiguration;
 * import com.pulumi.azurenative.networkcloud.MetricsConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var metricsConfiguration = new MetricsConfiguration("metricsConfiguration", MetricsConfigurationArgs.builder()
 *             .clusterName("clusterName")
 *             .collectionInterval(15)
 *             .enabledMetrics(
 *                 "metric1",
 *                 "metric2")
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .location("location")
 *             .metricsConfigurationName("default")
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:MetricsConfiguration default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/clusters/{clusterName}/metricsConfigurations/{metricsConfigurationName}
 * ```
 * @property clusterName The name of the cluster.
 * @property collectionInterval The interval in minutes by which metrics will be collected.
 * @property enabledMetrics The list of metric names that have been chosen to be enabled in addition to the core set of enabled metrics.
 * @property extendedLocation The extended location of the cluster associated with the resource.
 * @property location The geo-location where the resource lives
 * @property metricsConfigurationName The name of the metrics configuration for the cluster.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class MetricsConfigurationArgs(
    public val clusterName: Output<String>? = null,
    public val collectionInterval: Output<Double>? = null,
    public val enabledMetrics: Output<List<String>>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val location: Output<String>? = null,
    public val metricsConfigurationName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.MetricsConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.MetricsConfigurationArgs =
        com.pulumi.azurenative.networkcloud.MetricsConfigurationArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .collectionInterval(collectionInterval?.applyValue({ args0 -> args0 }))
            .enabledMetrics(enabledMetrics?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .metricsConfigurationName(metricsConfigurationName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MetricsConfigurationArgs].
 */
@PulumiTagMarker
public class MetricsConfigurationArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var collectionInterval: Output<Double>? = null

    private var enabledMetrics: Output<List<String>>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var location: Output<String>? = null

    private var metricsConfigurationName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the cluster.
     */
    @JvmName("uukwwpfwsksvfmli")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value The interval in minutes by which metrics will be collected.
     */
    @JvmName("djqjfpdwqkawaaiq")
    public suspend fun collectionInterval(`value`: Output<Double>) {
        this.collectionInterval = value
    }

    /**
     * @param value The list of metric names that have been chosen to be enabled in addition to the core set of enabled metrics.
     */
    @JvmName("iiqbwxnfivygjhnp")
    public suspend fun enabledMetrics(`value`: Output<List<String>>) {
        this.enabledMetrics = value
    }

    @JvmName("swbwenuxmfwkkqdp")
    public suspend fun enabledMetrics(vararg values: Output<String>) {
        this.enabledMetrics = Output.all(values.asList())
    }

    /**
     * @param values The list of metric names that have been chosen to be enabled in addition to the core set of enabled metrics.
     */
    @JvmName("yfcxiopdwyhkaikh")
    public suspend fun enabledMetrics(values: List<Output<String>>) {
        this.enabledMetrics = Output.all(values)
    }

    /**
     * @param value The extended location of the cluster associated with the resource.
     */
    @JvmName("surmfxbvfeffdegw")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("klgbfbwyqqxqqdco")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the metrics configuration for the cluster.
     */
    @JvmName("gmmmuinnkdeiombd")
    public suspend fun metricsConfigurationName(`value`: Output<String>) {
        this.metricsConfigurationName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xnhyfykyrnddtnft")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("lhinywduseifdext")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the cluster.
     */
    @JvmName("tucppvbpybalxuqm")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value The interval in minutes by which metrics will be collected.
     */
    @JvmName("ttsafgtichoqpegf")
    public suspend fun collectionInterval(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collectionInterval = mapped
    }

    /**
     * @param value The list of metric names that have been chosen to be enabled in addition to the core set of enabled metrics.
     */
    @JvmName("lfnihwhmvyuorlba")
    public suspend fun enabledMetrics(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledMetrics = mapped
    }

    /**
     * @param values The list of metric names that have been chosen to be enabled in addition to the core set of enabled metrics.
     */
    @JvmName("yedrkmdpfpvcrpus")
    public suspend fun enabledMetrics(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledMetrics = mapped
    }

    /**
     * @param value The extended location of the cluster associated with the resource.
     */
    @JvmName("piojftevpxncfnyq")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the cluster associated with the resource.
     */
    @JvmName("yqdibutktjpgiebu")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("fmeqykdmishqwirk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the metrics configuration for the cluster.
     */
    @JvmName("cphwgdtmvfajumxp")
    public suspend fun metricsConfigurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricsConfigurationName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("adipigdgyybqglbl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vxylcueefurhfrfi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ueaaqghstfpldgms")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MetricsConfigurationArgs = MetricsConfigurationArgs(
        clusterName = clusterName,
        collectionInterval = collectionInterval,
        enabledMetrics = enabledMetrics,
        extendedLocation = extendedLocation,
        location = location,
        metricsConfigurationName = metricsConfigurationName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
