@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.RackArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-12-12-preview.
 * Other available API versions: 2023-07-01, 2023-10-01-preview.
 * ## Example Usage
 * ### Create or update rack
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var rack = new AzureNative.NetworkCloud.Rack("rack", new()
 *     {
 *         AvailabilityZone = "1",
 *         ExtendedLocation = new AzureNative.NetworkCloud.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName",
 *             Type = "CustomLocation",
 *         },
 *         Location = "location",
 *         RackLocation = "Rack 28",
 *         RackName = "rackName",
 *         RackSerialNumber = "RACK_SERIAL_NUMBER",
 *         RackSkuId = "RACK-TYPE-1",
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkcloud.NewRack(ctx, "rack", &networkcloud.RackArgs{
 * 			AvailabilityZone: pulumi.String("1"),
 * 			ExtendedLocation: &networkcloud.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location:          pulumi.String("location"),
 * 			RackLocation:      pulumi.String("Rack 28"),
 * 			RackName:          pulumi.String("rackName"),
 * 			RackSerialNumber:  pulumi.String("RACK_SERIAL_NUMBER"),
 * 			RackSkuId:         pulumi.String("RACK-TYPE-1"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("myvalue1"),
 * 				"key2": pulumi.String("myvalue2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.Rack;
 * import com.pulumi.azurenative.networkcloud.RackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var rack = new Rack("rack", RackArgs.builder()
 *             .availabilityZone("1")
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .location("location")
 *             .rackLocation("Rack 28")
 *             .rackName("rackName")
 *             .rackSerialNumber("RACK_SERIAL_NUMBER")
 *             .rackSkuId("RACK-TYPE-1")
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:Rack rackName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/racks/{rackName}
 * ```
 * @property availabilityZone The value that will be used for machines in this rack to represent the availability zones that can be referenced by Hybrid AKS Clusters for node arrangement.
 * @property extendedLocation The extended location of the cluster associated with the resource.
 * @property location The geo-location where the resource lives
 * @property rackLocation The free-form description of the rack location. (e.g. “DTN Datacenter, Floor 3, Isle 9, Rack 2B”)
 * @property rackName The name of the rack.
 * @property rackSerialNumber The unique identifier for the rack within Network Cloud cluster. An alternate unique alphanumeric value other than a serial number may be provided if desired.
 * @property rackSkuId The SKU for the rack.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class RackArgs(
    public val availabilityZone: Output<String>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val location: Output<String>? = null,
    public val rackLocation: Output<String>? = null,
    public val rackName: Output<String>? = null,
    public val rackSerialNumber: Output<String>? = null,
    public val rackSkuId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.RackArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.RackArgs =
        com.pulumi.azurenative.networkcloud.RackArgs.builder()
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .rackLocation(rackLocation?.applyValue({ args0 -> args0 }))
            .rackName(rackName?.applyValue({ args0 -> args0 }))
            .rackSerialNumber(rackSerialNumber?.applyValue({ args0 -> args0 }))
            .rackSkuId(rackSkuId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RackArgs].
 */
@PulumiTagMarker
public class RackArgsBuilder internal constructor() {
    private var availabilityZone: Output<String>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var location: Output<String>? = null

    private var rackLocation: Output<String>? = null

    private var rackName: Output<String>? = null

    private var rackSerialNumber: Output<String>? = null

    private var rackSkuId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The value that will be used for machines in this rack to represent the availability zones that can be referenced by Hybrid AKS Clusters for node arrangement.
     */
    @JvmName("xfxigkliftigctdd")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value The extended location of the cluster associated with the resource.
     */
    @JvmName("jpokmbsyjuujnqbs")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("bakhrshsrremcive")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The free-form description of the rack location. (e.g. “DTN Datacenter, Floor 3, Isle 9, Rack 2B”)
     */
    @JvmName("ctkjioktbmstnxmw")
    public suspend fun rackLocation(`value`: Output<String>) {
        this.rackLocation = value
    }

    /**
     * @param value The name of the rack.
     */
    @JvmName("fgpwxpqkqxqlavcn")
    public suspend fun rackName(`value`: Output<String>) {
        this.rackName = value
    }

    /**
     * @param value The unique identifier for the rack within Network Cloud cluster. An alternate unique alphanumeric value other than a serial number may be provided if desired.
     */
    @JvmName("uiigksvnjwsgwanl")
    public suspend fun rackSerialNumber(`value`: Output<String>) {
        this.rackSerialNumber = value
    }

    /**
     * @param value The SKU for the rack.
     */
    @JvmName("raulwsfwdovsuege")
    public suspend fun rackSkuId(`value`: Output<String>) {
        this.rackSkuId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("juptvbfbskgncrqp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("pnkctsfeeocjyagq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The value that will be used for machines in this rack to represent the availability zones that can be referenced by Hybrid AKS Clusters for node arrangement.
     */
    @JvmName("hiohsoyydiqnrfqh")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value The extended location of the cluster associated with the resource.
     */
    @JvmName("jyyhyrkhafywyopc")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the cluster associated with the resource.
     */
    @JvmName("irsxpqwanxgeylxo")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("gtwldwudqpssrwjs")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The free-form description of the rack location. (e.g. “DTN Datacenter, Floor 3, Isle 9, Rack 2B”)
     */
    @JvmName("einejsummndnaxte")
    public suspend fun rackLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rackLocation = mapped
    }

    /**
     * @param value The name of the rack.
     */
    @JvmName("rwnlvygaohtretjg")
    public suspend fun rackName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rackName = mapped
    }

    /**
     * @param value The unique identifier for the rack within Network Cloud cluster. An alternate unique alphanumeric value other than a serial number may be provided if desired.
     */
    @JvmName("ubkciuwwofciaytm")
    public suspend fun rackSerialNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rackSerialNumber = mapped
    }

    /**
     * @param value The SKU for the rack.
     */
    @JvmName("gyxncigdodcecxtb")
    public suspend fun rackSkuId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rackSkuId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dqraowaosucvxutu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("civxipnckaklheul")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("thevkjmwvwbeaxvi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RackArgs = RackArgs(
        availabilityZone = availabilityZone,
        extendedLocation = extendedLocation,
        location = location,
        rackLocation = rackLocation,
        rackName = rackName,
        rackSerialNumber = rackSerialNumber,
        rackSkuId = rackSkuId,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
