@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.VirtualMachineArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.enums.VirtualMachineBootMethod
import com.pulumi.azurenative.networkcloud.kotlin.enums.VirtualMachineDeviceModelType
import com.pulumi.azurenative.networkcloud.kotlin.enums.VirtualMachineIsolateEmulatorThread
import com.pulumi.azurenative.networkcloud.kotlin.enums.VirtualMachineVirtioInterfaceType
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ImageRepositoryCredentialsArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ImageRepositoryCredentialsArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.NetworkAttachmentArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.NetworkAttachmentArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.SshPublicKeyArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.SshPublicKeyArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.StorageProfileArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.StorageProfileArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.VirtualMachinePlacementHintArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.VirtualMachinePlacementHintArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-12-12-preview.
 * Other available API versions: 2023-07-01, 2023-10-01-preview.
 * ## Example Usage
 * ### Create or update virtual machine
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.NetworkCloud.VirtualMachine("virtualMachine", new()
 *     {
 *         AdminUsername = "username",
 *         BootMethod = "UEFI",
 *         CloudServicesNetworkAttachment = new AzureNative.NetworkCloud.Inputs.NetworkAttachmentArgs
 *         {
 *             AttachedNetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/cloudServicesNetworks/cloudServicesNetworkName",
 *             IpAllocationMethod = "Dynamic",
 *         },
 *         CpuCores = 2,
 *         ExtendedLocation = new AzureNative.NetworkCloud.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName",
 *             Type = "CustomLocation",
 *         },
 *         Location = "location",
 *         MemorySizeGB = 8,
 *         NetworkAttachments = new[]
 *         {
 *             new AzureNative.NetworkCloud.Inputs.NetworkAttachmentArgs
 *             {
 *                 AttachedNetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName",
 *                 DefaultGateway = "True",
 *                 IpAllocationMethod = "Dynamic",
 *                 Ipv4Address = "198.51.100.1",
 *                 Ipv6Address = "2001:0db8:0000:0000:0000:0000:0000:0000",
 *                 NetworkAttachmentName = "netAttachName01",
 *             },
 *         },
 *         NetworkData = "bmV0d29ya0RhdGVTYW1wbGU=",
 *         PlacementHints = new[]
 *         {
 *             new AzureNative.NetworkCloud.Inputs.VirtualMachinePlacementHintArgs
 *             {
 *                 HintType = "Affinity",
 *                 ResourceId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/racks/rackName",
 *                 SchedulingExecution = "Hard",
 *                 Scope = "",
 *             },
 *         },
 *         ResourceGroupName = "resourceGroupName",
 *         SshPublicKeys = new[]
 *         {
 *             new AzureNative.NetworkCloud.Inputs.SshPublicKeyArgs
 *             {
 *                 KeyData = "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm",
 *             },
 *         },
 *         StorageProfile = new AzureNative.NetworkCloud.Inputs.StorageProfileArgs
 *         {
 *             OsDisk = new AzureNative.NetworkCloud.Inputs.OsDiskArgs
 *             {
 *                 CreateOption = "Ephemeral",
 *                 DeleteOption = "Delete",
 *                 DiskSizeGB = 120,
 *             },
 *             VolumeAttachments = new[]
 *             {
 *                 "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/volumes/volumeName",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *         UserData = "dXNlckRhdGVTYW1wbGU=",
 *         VirtualMachineName = "virtualMachineName",
 *         VmDeviceModel = "T2",
 *         VmImage = "myacr.azurecr.io/foobar:latest",
 *         VmImageRepositoryCredentials = new AzureNative.NetworkCloud.Inputs.ImageRepositoryCredentialsArgs
 *         {
 *             Password = "{password}",
 *             RegistryUrl = "myacr.azurecr.io",
 *             Username = "myuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkcloud.NewVirtualMachine(ctx, "virtualMachine", &networkcloud.VirtualMachineArgs{
 * 			AdminUsername: pulumi.String("username"),
 * 			BootMethod:    pulumi.String("UEFI"),
 * 			CloudServicesNetworkAttachment: &networkcloud.NetworkAttachmentArgs{
 * 				AttachedNetworkId:  pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/cloudServicesNetworks/cloudServicesNetworkName"),
 * 				IpAllocationMethod: pulumi.String("Dynamic"),
 * 			},
 * 			CpuCores: pulumi.Float64(2),
 * 			ExtendedLocation: &networkcloud.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location:     pulumi.String("location"),
 * 			MemorySizeGB: pulumi.Float64(8),
 * 			NetworkAttachments: []networkcloud.NetworkAttachmentArgs{
 * 				{
 * 					AttachedNetworkId:     pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
 * 					DefaultGateway:        pulumi.String("True"),
 * 					IpAllocationMethod:    pulumi.String("Dynamic"),
 * 					Ipv4Address:           pulumi.String("198.51.100.1"),
 * 					Ipv6Address:           pulumi.String("2001:0db8:0000:0000:0000:0000:0000:0000"),
 * 					NetworkAttachmentName: pulumi.String("netAttachName01"),
 * 				},
 * 			},
 * 			NetworkData: pulumi.String("bmV0d29ya0RhdGVTYW1wbGU="),
 * 			PlacementHints: []networkcloud.VirtualMachinePlacementHintArgs{
 * 				{
 * 					HintType:            pulumi.String("Affinity"),
 * 					ResourceId:          pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/racks/rackName"),
 * 					SchedulingExecution: pulumi.String("Hard"),
 * 					Scope:               pulumi.String(""),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			SshPublicKeys: []networkcloud.SshPublicKeyArgs{
 * 				{
 * 					KeyData: pulumi.String("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"),
 * 				},
 * 			},
 * 			StorageProfile: networkcloud.StorageProfileResponse{
 * 				OsDisk: &networkcloud.OsDiskArgs{
 * 					CreateOption: pulumi.String("Ephemeral"),
 * 					DeleteOption: pulumi.String("Delete"),
 * 					DiskSizeGB:   pulumi.Float64(120),
 * 				},
 * 				VolumeAttachments: pulumi.StringArray{
 * 					pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/volumes/volumeName"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("myvalue1"),
 * 				"key2": pulumi.String("myvalue2"),
 * 			},
 * 			UserData:           pulumi.String("dXNlckRhdGVTYW1wbGU="),
 * 			VirtualMachineName: pulumi.String("virtualMachineName"),
 * 			VmDeviceModel:      pulumi.String("T2"),
 * 			VmImage:            pulumi.String("myacr.azurecr.io/foobar:latest"),
 * 			VmImageRepositoryCredentials: &networkcloud.ImageRepositoryCredentialsArgs{
 * 				Password:    pulumi.String("{password}"),
 * 				RegistryUrl: pulumi.String("myacr.azurecr.io"),
 * 				Username:    pulumi.String("myuser"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.VirtualMachine;
 * import com.pulumi.azurenative.networkcloud.VirtualMachineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .adminUsername("username")
 *             .bootMethod("UEFI")
 *             .cloudServicesNetworkAttachment(Map.ofEntries(
 *                 Map.entry("attachedNetworkId", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/cloudServicesNetworks/cloudServicesNetworkName"),
 *                 Map.entry("ipAllocationMethod", "Dynamic")
 *             ))
 *             .cpuCores(2)
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .location("location")
 *             .memorySizeGB(8)
 *             .networkAttachments(Map.ofEntries(
 *                 Map.entry("attachedNetworkId", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
 *                 Map.entry("defaultGateway", "True"),
 *                 Map.entry("ipAllocationMethod", "Dynamic"),
 *                 Map.entry("ipv4Address", "198.51.100.1"),
 *                 Map.entry("ipv6Address", "2001:0db8:0000:0000:0000:0000:0000:0000"),
 *                 Map.entry("networkAttachmentName", "netAttachName01")
 *             ))
 *             .networkData("bmV0d29ya0RhdGVTYW1wbGU=")
 *             .placementHints(Map.ofEntries(
 *                 Map.entry("hintType", "Affinity"),
 *                 Map.entry("resourceId", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/racks/rackName"),
 *                 Map.entry("schedulingExecution", "Hard"),
 *                 Map.entry("scope", "")
 *             ))
 *             .resourceGroupName("resourceGroupName")
 *             .sshPublicKeys(Map.of("keyData", "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"))
 *             .storageProfile(Map.ofEntries(
 *                 Map.entry("osDisk", Map.ofEntries(
 *                     Map.entry("createOption", "Ephemeral"),
 *                     Map.entry("deleteOption", "Delete"),
 *                     Map.entry("diskSizeGB", 120)
 *                 )),
 *                 Map.entry("volumeAttachments", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/volumes/volumeName")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .userData("dXNlckRhdGVTYW1wbGU=")
 *             .virtualMachineName("virtualMachineName")
 *             .vmDeviceModel("T2")
 *             .vmImage("myacr.azurecr.io/foobar:latest")
 *             .vmImageRepositoryCredentials(Map.ofEntries(
 *                 Map.entry("password", "{password}"),
 *                 Map.entry("registryUrl", "myacr.azurecr.io"),
 *                 Map.entry("username", "myuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:VirtualMachine virtualMachineName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/virtualMachines/{virtualMachineName}
 * ```
 * @property adminUsername The name of the administrator to which the ssh public keys will be added into the authorized keys.
 * @property bootMethod Selects the boot method for the virtual machine.
 * @property cloudServicesNetworkAttachment The cloud service network that provides platform-level services for the virtual machine.
 * @property cpuCores The number of CPU cores in the virtual machine.
 * @property extendedLocation The extended location of the cluster associated with the resource.
 * @property isolateEmulatorThread Field Deprecated, the value will be ignored if provided. The indicator of whether one of the specified CPU cores is isolated to run the emulator thread for this virtual machine.
 * @property location The geo-location where the resource lives
 * @property memorySizeGB The memory size of the virtual machine in GB.
 * @property networkAttachments The list of network attachments to the virtual machine.
 * @property networkData The Base64 encoded cloud-init network data.
 * @property placementHints The scheduling hints for the virtual machine.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sshPublicKeys The list of ssh public keys. Each key will be added to the virtual machine using the cloud-init ssh_authorized_keys mechanism for the adminUsername.
 * @property storageProfile The storage profile that specifies size and other parameters about the disks related to the virtual machine.
 * @property tags Resource tags.
 * @property userData The Base64 encoded cloud-init user data.
 * @property virtioInterface Field Deprecated, use virtualizationModel instead. The type of the virtio interface.
 * @property virtualMachineName The name of the virtual machine.
 * @property vmDeviceModel The type of the device model to use.
 * @property vmImage The virtual machine image that is currently provisioned to the OS disk, using the full url and tag notation used to pull the image.
 * @property vmImageRepositoryCredentials The credentials used to login to the image repository that has access to the specified image.
 */
public data class VirtualMachineArgs(
    public val adminUsername: Output<String>? = null,
    public val bootMethod: Output<Either<String, VirtualMachineBootMethod>>? = null,
    public val cloudServicesNetworkAttachment: Output<NetworkAttachmentArgs>? = null,
    public val cpuCores: Output<Double>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val isolateEmulatorThread: Output<Either<String, VirtualMachineIsolateEmulatorThread>>? =
        null,
    public val location: Output<String>? = null,
    public val memorySizeGB: Output<Double>? = null,
    public val networkAttachments: Output<List<NetworkAttachmentArgs>>? = null,
    public val networkData: Output<String>? = null,
    public val placementHints: Output<List<VirtualMachinePlacementHintArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sshPublicKeys: Output<List<SshPublicKeyArgs>>? = null,
    public val storageProfile: Output<StorageProfileArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userData: Output<String>? = null,
    public val virtioInterface: Output<Either<String, VirtualMachineVirtioInterfaceType>>? = null,
    public val virtualMachineName: Output<String>? = null,
    public val vmDeviceModel: Output<Either<String, VirtualMachineDeviceModelType>>? = null,
    public val vmImage: Output<String>? = null,
    public val vmImageRepositoryCredentials: Output<ImageRepositoryCredentialsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.VirtualMachineArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.VirtualMachineArgs =
        com.pulumi.azurenative.networkcloud.VirtualMachineArgs.builder()
            .adminUsername(adminUsername?.applyValue({ args0 -> args0 }))
            .bootMethod(
                bootMethod?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .cloudServicesNetworkAttachment(
                cloudServicesNetworkAttachment?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .cpuCores(cpuCores?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .isolateEmulatorThread(
                isolateEmulatorThread?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .memorySizeGB(memorySizeGB?.applyValue({ args0 -> args0 }))
            .networkAttachments(
                networkAttachments?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .networkData(networkData?.applyValue({ args0 -> args0 }))
            .placementHints(
                placementHints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sshPublicKeys(
                sshPublicKeys?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .storageProfile(storageProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userData(userData?.applyValue({ args0 -> args0 }))
            .virtioInterface(
                virtioInterface?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .virtualMachineName(virtualMachineName?.applyValue({ args0 -> args0 }))
            .vmDeviceModel(
                vmDeviceModel?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .vmImage(vmImage?.applyValue({ args0 -> args0 }))
            .vmImageRepositoryCredentials(
                vmImageRepositoryCredentials?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [VirtualMachineArgs].
 */
@PulumiTagMarker
public class VirtualMachineArgsBuilder internal constructor() {
    private var adminUsername: Output<String>? = null

    private var bootMethod: Output<Either<String, VirtualMachineBootMethod>>? = null

    private var cloudServicesNetworkAttachment: Output<NetworkAttachmentArgs>? = null

    private var cpuCores: Output<Double>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var isolateEmulatorThread: Output<Either<String, VirtualMachineIsolateEmulatorThread>>? =
        null

    private var location: Output<String>? = null

    private var memorySizeGB: Output<Double>? = null

    private var networkAttachments: Output<List<NetworkAttachmentArgs>>? = null

    private var networkData: Output<String>? = null

    private var placementHints: Output<List<VirtualMachinePlacementHintArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var sshPublicKeys: Output<List<SshPublicKeyArgs>>? = null

    private var storageProfile: Output<StorageProfileArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userData: Output<String>? = null

    private var virtioInterface: Output<Either<String, VirtualMachineVirtioInterfaceType>>? = null

    private var virtualMachineName: Output<String>? = null

    private var vmDeviceModel: Output<Either<String, VirtualMachineDeviceModelType>>? = null

    private var vmImage: Output<String>? = null

    private var vmImageRepositoryCredentials: Output<ImageRepositoryCredentialsArgs>? = null

    /**
     * @param value The name of the administrator to which the ssh public keys will be added into the authorized keys.
     */
    @JvmName("khruqsblygctwbjk")
    public suspend fun adminUsername(`value`: Output<String>) {
        this.adminUsername = value
    }

    /**
     * @param value Selects the boot method for the virtual machine.
     */
    @JvmName("agsohqqlqmidcdje")
    public suspend fun bootMethod(`value`: Output<Either<String, VirtualMachineBootMethod>>) {
        this.bootMethod = value
    }

    /**
     * @param value The cloud service network that provides platform-level services for the virtual machine.
     */
    @JvmName("navvhwqlxkpafyqq")
    public suspend fun cloudServicesNetworkAttachment(`value`: Output<NetworkAttachmentArgs>) {
        this.cloudServicesNetworkAttachment = value
    }

    /**
     * @param value The number of CPU cores in the virtual machine.
     */
    @JvmName("ewfcalclojecxxid")
    public suspend fun cpuCores(`value`: Output<Double>) {
        this.cpuCores = value
    }

    /**
     * @param value The extended location of the cluster associated with the resource.
     */
    @JvmName("hfpcvucjsoqsvvbl")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Field Deprecated, the value will be ignored if provided. The indicator of whether one of the specified CPU cores is isolated to run the emulator thread for this virtual machine.
     */
    @JvmName("qeoykqqiukbukbpb")
    public suspend
    fun isolateEmulatorThread(`value`: Output<Either<String, VirtualMachineIsolateEmulatorThread>>) {
        this.isolateEmulatorThread = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ediqlqhubarxehnm")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The memory size of the virtual machine in GB.
     */
    @JvmName("tpuowitdkxnqufty")
    public suspend fun memorySizeGB(`value`: Output<Double>) {
        this.memorySizeGB = value
    }

    /**
     * @param value The list of network attachments to the virtual machine.
     */
    @JvmName("ftwayucdhdopdraf")
    public suspend fun networkAttachments(`value`: Output<List<NetworkAttachmentArgs>>) {
        this.networkAttachments = value
    }

    @JvmName("vghdxgqdrfjbxvuy")
    public suspend fun networkAttachments(vararg values: Output<NetworkAttachmentArgs>) {
        this.networkAttachments = Output.all(values.asList())
    }

    /**
     * @param values The list of network attachments to the virtual machine.
     */
    @JvmName("lgkdcngbgwkjynev")
    public suspend fun networkAttachments(values: List<Output<NetworkAttachmentArgs>>) {
        this.networkAttachments = Output.all(values)
    }

    /**
     * @param value The Base64 encoded cloud-init network data.
     */
    @JvmName("apksexqkusqkrjkf")
    public suspend fun networkData(`value`: Output<String>) {
        this.networkData = value
    }

    /**
     * @param value The scheduling hints for the virtual machine.
     */
    @JvmName("yvddfrfrphypsfqn")
    public suspend fun placementHints(`value`: Output<List<VirtualMachinePlacementHintArgs>>) {
        this.placementHints = value
    }

    @JvmName("phrumgtoihoggtqc")
    public suspend fun placementHints(vararg values: Output<VirtualMachinePlacementHintArgs>) {
        this.placementHints = Output.all(values.asList())
    }

    /**
     * @param values The scheduling hints for the virtual machine.
     */
    @JvmName("dyrtjoimylqxpuqp")
    public suspend fun placementHints(values: List<Output<VirtualMachinePlacementHintArgs>>) {
        this.placementHints = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("uhqmetjelvvloyec")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The list of ssh public keys. Each key will be added to the virtual machine using the cloud-init ssh_authorized_keys mechanism for the adminUsername.
     */
    @JvmName("cvyocthdxnvhcavs")
    public suspend fun sshPublicKeys(`value`: Output<List<SshPublicKeyArgs>>) {
        this.sshPublicKeys = value
    }

    @JvmName("ynebumrdvrgrkxfd")
    public suspend fun sshPublicKeys(vararg values: Output<SshPublicKeyArgs>) {
        this.sshPublicKeys = Output.all(values.asList())
    }

    /**
     * @param values The list of ssh public keys. Each key will be added to the virtual machine using the cloud-init ssh_authorized_keys mechanism for the adminUsername.
     */
    @JvmName("tvtsrkkdliuagutg")
    public suspend fun sshPublicKeys(values: List<Output<SshPublicKeyArgs>>) {
        this.sshPublicKeys = Output.all(values)
    }

    /**
     * @param value The storage profile that specifies size and other parameters about the disks related to the virtual machine.
     */
    @JvmName("wapdysahhmqppurx")
    public suspend fun storageProfile(`value`: Output<StorageProfileArgs>) {
        this.storageProfile = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("iamtkoxnbjodckkh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Base64 encoded cloud-init user data.
     */
    @JvmName("qbcbrkclpwqyawcq")
    public suspend fun userData(`value`: Output<String>) {
        this.userData = value
    }

    /**
     * @param value Field Deprecated, use virtualizationModel instead. The type of the virtio interface.
     */
    @JvmName("auerhtxdmtxbptvs")
    public suspend
    fun virtioInterface(`value`: Output<Either<String, VirtualMachineVirtioInterfaceType>>) {
        this.virtioInterface = value
    }

    /**
     * @param value The name of the virtual machine.
     */
    @JvmName("dvuvwkixdcadblyi")
    public suspend fun virtualMachineName(`value`: Output<String>) {
        this.virtualMachineName = value
    }

    /**
     * @param value The type of the device model to use.
     */
    @JvmName("vumkdgmixwqdffkk")
    public suspend fun vmDeviceModel(`value`: Output<Either<String, VirtualMachineDeviceModelType>>) {
        this.vmDeviceModel = value
    }

    /**
     * @param value The virtual machine image that is currently provisioned to the OS disk, using the full url and tag notation used to pull the image.
     */
    @JvmName("hnkjvgviwiunftkv")
    public suspend fun vmImage(`value`: Output<String>) {
        this.vmImage = value
    }

    /**
     * @param value The credentials used to login to the image repository that has access to the specified image.
     */
    @JvmName("djeahwnwiuesavjy")
    public suspend fun vmImageRepositoryCredentials(`value`: Output<ImageRepositoryCredentialsArgs>) {
        this.vmImageRepositoryCredentials = value
    }

    /**
     * @param value The name of the administrator to which the ssh public keys will be added into the authorized keys.
     */
    @JvmName("vubjpvmgcddncclw")
    public suspend fun adminUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminUsername = mapped
    }

    /**
     * @param value Selects the boot method for the virtual machine.
     */
    @JvmName("fpgtvvcvdealcfxw")
    public suspend fun bootMethod(`value`: Either<String, VirtualMachineBootMethod>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bootMethod = mapped
    }

    /**
     * @param value Selects the boot method for the virtual machine.
     */
    @JvmName("ljtedynbwndnndxe")
    public fun bootMethod(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualMachineBootMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bootMethod = mapped
    }

    /**
     * @param value Selects the boot method for the virtual machine.
     */
    @JvmName("xwxdcddpwevejfqp")
    public fun bootMethod(`value`: VirtualMachineBootMethod) {
        val toBeMapped = Either.ofRight<String, VirtualMachineBootMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bootMethod = mapped
    }

    /**
     * @param value The cloud service network that provides platform-level services for the virtual machine.
     */
    @JvmName("pobytdhsdbsgtoxp")
    public suspend fun cloudServicesNetworkAttachment(`value`: NetworkAttachmentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudServicesNetworkAttachment = mapped
    }

    /**
     * @param argument The cloud service network that provides platform-level services for the virtual machine.
     */
    @JvmName("xiyxribnqgodqqly")
    public suspend
    fun cloudServicesNetworkAttachment(argument: suspend NetworkAttachmentArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkAttachmentArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cloudServicesNetworkAttachment = mapped
    }

    /**
     * @param value The number of CPU cores in the virtual machine.
     */
    @JvmName("xsrixajghfgjprup")
    public suspend fun cpuCores(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpuCores = mapped
    }

    /**
     * @param value The extended location of the cluster associated with the resource.
     */
    @JvmName("dspwxjrxpoltseaa")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the cluster associated with the resource.
     */
    @JvmName("cjagignuumrthgas")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Field Deprecated, the value will be ignored if provided. The indicator of whether one of the specified CPU cores is isolated to run the emulator thread for this virtual machine.
     */
    @JvmName("rcglwprjkrumgxju")
    public suspend
    fun isolateEmulatorThread(`value`: Either<String, VirtualMachineIsolateEmulatorThread>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isolateEmulatorThread = mapped
    }

    /**
     * @param value Field Deprecated, the value will be ignored if provided. The indicator of whether one of the specified CPU cores is isolated to run the emulator thread for this virtual machine.
     */
    @JvmName("fvhthvnlstygxjko")
    public fun isolateEmulatorThread(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualMachineIsolateEmulatorThread>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isolateEmulatorThread = mapped
    }

    /**
     * @param value Field Deprecated, the value will be ignored if provided. The indicator of whether one of the specified CPU cores is isolated to run the emulator thread for this virtual machine.
     */
    @JvmName("bjoufblqjpwlmsoy")
    public fun isolateEmulatorThread(`value`: VirtualMachineIsolateEmulatorThread) {
        val toBeMapped = Either.ofRight<String, VirtualMachineIsolateEmulatorThread>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isolateEmulatorThread = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("eayptbwylkucyxgq")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The memory size of the virtual machine in GB.
     */
    @JvmName("plqgdotbgbarredt")
    public suspend fun memorySizeGB(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memorySizeGB = mapped
    }

    /**
     * @param value The list of network attachments to the virtual machine.
     */
    @JvmName("lvulouaplnlemibw")
    public suspend fun networkAttachments(`value`: List<NetworkAttachmentArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkAttachments = mapped
    }

    /**
     * @param argument The list of network attachments to the virtual machine.
     */
    @JvmName("bliaxmiitnmguxfy")
    public suspend
    fun networkAttachments(argument: List<suspend NetworkAttachmentArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NetworkAttachmentArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.networkAttachments = mapped
    }

    /**
     * @param argument The list of network attachments to the virtual machine.
     */
    @JvmName("fssgmhhxovtmdbrs")
    public suspend fun networkAttachments(
        vararg
        argument: suspend NetworkAttachmentArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            NetworkAttachmentArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.networkAttachments = mapped
    }

    /**
     * @param argument The list of network attachments to the virtual machine.
     */
    @JvmName("gfvaxirarqihkwyr")
    public suspend fun networkAttachments(argument: suspend NetworkAttachmentArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NetworkAttachmentArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.networkAttachments = mapped
    }

    /**
     * @param values The list of network attachments to the virtual machine.
     */
    @JvmName("elxdiqlxvgpfpyme")
    public suspend fun networkAttachments(vararg values: NetworkAttachmentArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkAttachments = mapped
    }

    /**
     * @param value The Base64 encoded cloud-init network data.
     */
    @JvmName("vxnjchrvgrvmpxoe")
    public suspend fun networkData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkData = mapped
    }

    /**
     * @param value The scheduling hints for the virtual machine.
     */
    @JvmName("rlyaskfahivqsioy")
    public suspend fun placementHints(`value`: List<VirtualMachinePlacementHintArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placementHints = mapped
    }

    /**
     * @param argument The scheduling hints for the virtual machine.
     */
    @JvmName("ehgyitjfcsbusica")
    public suspend
    fun placementHints(argument: List<suspend VirtualMachinePlacementHintArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualMachinePlacementHintArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.placementHints = mapped
    }

    /**
     * @param argument The scheduling hints for the virtual machine.
     */
    @JvmName("esmaeqxdtysyiobh")
    public suspend fun placementHints(
        vararg
        argument: suspend VirtualMachinePlacementHintArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualMachinePlacementHintArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.placementHints = mapped
    }

    /**
     * @param argument The scheduling hints for the virtual machine.
     */
    @JvmName("rtuhyxtbhypsqmit")
    public suspend
    fun placementHints(argument: suspend VirtualMachinePlacementHintArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualMachinePlacementHintArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.placementHints = mapped
    }

    /**
     * @param values The scheduling hints for the virtual machine.
     */
    @JvmName("nhoobtrqugssupab")
    public suspend fun placementHints(vararg values: VirtualMachinePlacementHintArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.placementHints = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nbbcparsxwdjtsxi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The list of ssh public keys. Each key will be added to the virtual machine using the cloud-init ssh_authorized_keys mechanism for the adminUsername.
     */
    @JvmName("koniqdlfbgjauedi")
    public suspend fun sshPublicKeys(`value`: List<SshPublicKeyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sshPublicKeys = mapped
    }

    /**
     * @param argument The list of ssh public keys. Each key will be added to the virtual machine using the cloud-init ssh_authorized_keys mechanism for the adminUsername.
     */
    @JvmName("dbxjixrqunjijcuu")
    public suspend fun sshPublicKeys(argument: List<suspend SshPublicKeyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SshPublicKeyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sshPublicKeys = mapped
    }

    /**
     * @param argument The list of ssh public keys. Each key will be added to the virtual machine using the cloud-init ssh_authorized_keys mechanism for the adminUsername.
     */
    @JvmName("sdovieiuwmonwqpw")
    public suspend fun sshPublicKeys(vararg argument: suspend SshPublicKeyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SshPublicKeyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sshPublicKeys = mapped
    }

    /**
     * @param argument The list of ssh public keys. Each key will be added to the virtual machine using the cloud-init ssh_authorized_keys mechanism for the adminUsername.
     */
    @JvmName("jsnhmunddgpxtjie")
    public suspend fun sshPublicKeys(argument: suspend SshPublicKeyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SshPublicKeyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sshPublicKeys = mapped
    }

    /**
     * @param values The list of ssh public keys. Each key will be added to the virtual machine using the cloud-init ssh_authorized_keys mechanism for the adminUsername.
     */
    @JvmName("tewnvkkabgwwidwp")
    public suspend fun sshPublicKeys(vararg values: SshPublicKeyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sshPublicKeys = mapped
    }

    /**
     * @param value The storage profile that specifies size and other parameters about the disks related to the virtual machine.
     */
    @JvmName("niwmatjygtydnutn")
    public suspend fun storageProfile(`value`: StorageProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageProfile = mapped
    }

    /**
     * @param argument The storage profile that specifies size and other parameters about the disks related to the virtual machine.
     */
    @JvmName("ilvfncupegsmytrx")
    public suspend fun storageProfile(argument: suspend StorageProfileArgsBuilder.() -> Unit) {
        val toBeMapped = StorageProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageProfile = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fnbekiytkssbiseo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("xwojkcwqwgqufbqv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The Base64 encoded cloud-init user data.
     */
    @JvmName("xaodytrnnqqrqovm")
    public suspend fun userData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userData = mapped
    }

    /**
     * @param value Field Deprecated, use virtualizationModel instead. The type of the virtio interface.
     */
    @JvmName("ybwwdpfxcfnrlhix")
    public suspend fun virtioInterface(`value`: Either<String, VirtualMachineVirtioInterfaceType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtioInterface = mapped
    }

    /**
     * @param value Field Deprecated, use virtualizationModel instead. The type of the virtio interface.
     */
    @JvmName("qymvmbludydjskfn")
    public fun virtioInterface(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualMachineVirtioInterfaceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtioInterface = mapped
    }

    /**
     * @param value Field Deprecated, use virtualizationModel instead. The type of the virtio interface.
     */
    @JvmName("rkitlymfxqvqmllr")
    public fun virtioInterface(`value`: VirtualMachineVirtioInterfaceType) {
        val toBeMapped = Either.ofRight<String, VirtualMachineVirtioInterfaceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtioInterface = mapped
    }

    /**
     * @param value The name of the virtual machine.
     */
    @JvmName("lhsilvcobdkofxos")
    public suspend fun virtualMachineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualMachineName = mapped
    }

    /**
     * @param value The type of the device model to use.
     */
    @JvmName("flnpbgthunaxswfi")
    public suspend fun vmDeviceModel(`value`: Either<String, VirtualMachineDeviceModelType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmDeviceModel = mapped
    }

    /**
     * @param value The type of the device model to use.
     */
    @JvmName("jlkqfwmvibkpdrpo")
    public fun vmDeviceModel(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualMachineDeviceModelType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmDeviceModel = mapped
    }

    /**
     * @param value The type of the device model to use.
     */
    @JvmName("munoyaoncyrxwdnw")
    public fun vmDeviceModel(`value`: VirtualMachineDeviceModelType) {
        val toBeMapped = Either.ofRight<String, VirtualMachineDeviceModelType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmDeviceModel = mapped
    }

    /**
     * @param value The virtual machine image that is currently provisioned to the OS disk, using the full url and tag notation used to pull the image.
     */
    @JvmName("kohcvirhqfnbbbvn")
    public suspend fun vmImage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmImage = mapped
    }

    /**
     * @param value The credentials used to login to the image repository that has access to the specified image.
     */
    @JvmName("qdiuknfghwfsdaix")
    public suspend fun vmImageRepositoryCredentials(`value`: ImageRepositoryCredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmImageRepositoryCredentials = mapped
    }

    /**
     * @param argument The credentials used to login to the image repository that has access to the specified image.
     */
    @JvmName("ihnlcvlkmyahncpp")
    public suspend
    fun vmImageRepositoryCredentials(argument: suspend ImageRepositoryCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = ImageRepositoryCredentialsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vmImageRepositoryCredentials = mapped
    }

    internal fun build(): VirtualMachineArgs = VirtualMachineArgs(
        adminUsername = adminUsername,
        bootMethod = bootMethod,
        cloudServicesNetworkAttachment = cloudServicesNetworkAttachment,
        cpuCores = cpuCores,
        extendedLocation = extendedLocation,
        isolateEmulatorThread = isolateEmulatorThread,
        location = location,
        memorySizeGB = memorySizeGB,
        networkAttachments = networkAttachments,
        networkData = networkData,
        placementHints = placementHints,
        resourceGroupName = resourceGroupName,
        sshPublicKeys = sshPublicKeys,
        storageProfile = storageProfile,
        tags = tags,
        userData = userData,
        virtioInterface = virtioInterface,
        virtualMachineName = virtualMachineName,
        vmDeviceModel = vmDeviceModel,
        vmImage = vmImage,
        vmImageRepositoryCredentials = vmImageRepositoryCredentials,
    )
}
