@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.VolumeArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-12-12-preview.
 * Other available API versions: 2023-07-01, 2023-10-01-preview.
 * ## Example Usage
 * ### Create or update volume
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var volume = new AzureNative.NetworkCloud.Volume("volume", new()
 *     {
 *         ExtendedLocation = new AzureNative.NetworkCloud.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName",
 *             Type = "CustomLocation",
 *         },
 *         Location = "location",
 *         ResourceGroupName = "resourceGroupName",
 *         SizeMiB = 10000,
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *         VolumeName = "volumeName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkcloud.NewVolume(ctx, "volume", &networkcloud.VolumeArgs{
 * 			ExtendedLocation: &networkcloud.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location:          pulumi.String("location"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			SizeMiB:           pulumi.Float64(10000),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("myvalue1"),
 * 				"key2": pulumi.String("myvalue2"),
 * 			},
 * 			VolumeName: pulumi.String("volumeName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.Volume;
 * import com.pulumi.azurenative.networkcloud.VolumeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var volume = new Volume("volume", VolumeArgs.builder()
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .location("location")
 *             .resourceGroupName("resourceGroupName")
 *             .sizeMiB(10000)
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .volumeName("volumeName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:Volume volumeName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/volumes/{volumeName}
 * ```
 * @property extendedLocation The extended location of the cluster associated with the resource.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sizeMiB The size of the allocation for this volume in Mebibytes.
 * @property tags Resource tags.
 * @property volumeName The name of the volume.
 */
public data class VolumeArgs(
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sizeMiB: Output<Double>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val volumeName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.VolumeArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.VolumeArgs =
        com.pulumi.azurenative.networkcloud.VolumeArgs.builder()
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sizeMiB(sizeMiB?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .volumeName(volumeName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VolumeArgs].
 */
@PulumiTagMarker
public class VolumeArgsBuilder internal constructor() {
    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sizeMiB: Output<Double>? = null

    private var tags: Output<Map<String, String>>? = null

    private var volumeName: Output<String>? = null

    /**
     * @param value The extended location of the cluster associated with the resource.
     */
    @JvmName("fytiasisuwcclxgj")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ffsvoucwveapfvmf")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jnjpdjgwoxhgppqm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The size of the allocation for this volume in Mebibytes.
     */
    @JvmName("wsspgospylujfokw")
    public suspend fun sizeMiB(`value`: Output<Double>) {
        this.sizeMiB = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("encxwkjcgkxhejuu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the volume.
     */
    @JvmName("glhycgqwdflcsxwy")
    public suspend fun volumeName(`value`: Output<String>) {
        this.volumeName = value
    }

    /**
     * @param value The extended location of the cluster associated with the resource.
     */
    @JvmName("hubktiajacsoghdl")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the cluster associated with the resource.
     */
    @JvmName("dpvvpswtcukpqspt")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("kwjrgtwmahmnlifv")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("flktkjqpkyidrwyl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The size of the allocation for this volume in Mebibytes.
     */
    @JvmName("mcuigjoyitfonxmb")
    public suspend fun sizeMiB(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sizeMiB = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("cktemnoemjedyhcm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("daxkfxvmdurrhpjg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the volume.
     */
    @JvmName("bpkoqfvivkhruvoq")
    public suspend fun volumeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeName = mapped
    }

    internal fun build(): VolumeArgs = VolumeArgs(
        extendedLocation = extendedLocation,
        location = location,
        resourceGroupName = resourceGroupName,
        sizeMiB = sizeMiB,
        tags = tags,
        volumeName = volumeName,
    )
}
