@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The indicator of whether or not to disable IPAM allocation on the network attachment definition injected into the Hybrid AKS Cluster.
 */
public enum class HybridAksIpamEnabled(
    public val javaValue: com.pulumi.azurenative.networkcloud.enums.HybridAksIpamEnabled,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.enums.HybridAksIpamEnabled> {
    True(com.pulumi.azurenative.networkcloud.enums.HybridAksIpamEnabled.True),
    False(com.pulumi.azurenative.networkcloud.enums.HybridAksIpamEnabled.False),
    ;

    override fun toJava(): com.pulumi.azurenative.networkcloud.enums.HybridAksIpamEnabled = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.enums.HybridAksIpamEnabled):
            HybridAksIpamEnabled = HybridAksIpamEnabled.values().first { it.javaValue == javaType }
    }
}
