@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.AdministrativeCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property password The password of the administrator of the device used during initialization.
 * @property username The username of the administrator of the device used during initialization.
 */
public data class AdministrativeCredentialsArgs(
    public val password: Output<String>,
    public val username: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.AdministrativeCredentialsArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.AdministrativeCredentialsArgs =
        com.pulumi.azurenative.networkcloud.inputs.AdministrativeCredentialsArgs.builder()
            .password(password.applyValue({ args0 -> args0 }))
            .username(username.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AdministrativeCredentialsArgs].
 */
@PulumiTagMarker
public class AdministrativeCredentialsArgsBuilder internal constructor() {
    private var password: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value The password of the administrator of the device used during initialization.
     */
    @JvmName("xivecbpdnanjjubl")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The username of the administrator of the device used during initialization.
     */
    @JvmName("rcapeutdsqnrkqsh")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value The password of the administrator of the device used during initialization.
     */
    @JvmName("wwthklppdbiimfer")
    public suspend fun password(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The username of the administrator of the device used during initialization.
     */
    @JvmName("khogfrqrhdvlyxhs")
    public suspend fun username(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): AdministrativeCredentialsArgs = AdministrativeCredentialsArgs(
        password = password ?: throw PulumiNullFieldException("password"),
        username = username ?: throw PulumiNullFieldException("username"),
    )
}
