@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.AdministratorConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property adminUsername The user name for the administrator that will be applied to the operating systems that run Kubernetes nodes. If not supplied, a user name will be chosen by the service.
 * @property sshPublicKeys The SSH configuration for the operating systems that run the nodes in the Kubernetes cluster. In some cases, specification of public keys may be required to produce a working environment.
 */
public data class AdministratorConfigurationArgs(
    public val adminUsername: Output<String>? = null,
    public val sshPublicKeys: Output<List<SshPublicKeyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.AdministratorConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.AdministratorConfigurationArgs =
        com.pulumi.azurenative.networkcloud.inputs.AdministratorConfigurationArgs.builder()
            .adminUsername(adminUsername?.applyValue({ args0 -> args0 }))
            .sshPublicKeys(
                sshPublicKeys?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AdministratorConfigurationArgs].
 */
@PulumiTagMarker
public class AdministratorConfigurationArgsBuilder internal constructor() {
    private var adminUsername: Output<String>? = null

    private var sshPublicKeys: Output<List<SshPublicKeyArgs>>? = null

    /**
     * @param value The user name for the administrator that will be applied to the operating systems that run Kubernetes nodes. If not supplied, a user name will be chosen by the service.
     */
    @JvmName("vyaannddtyqbtxlh")
    public suspend fun adminUsername(`value`: Output<String>) {
        this.adminUsername = value
    }

    /**
     * @param value The SSH configuration for the operating systems that run the nodes in the Kubernetes cluster. In some cases, specification of public keys may be required to produce a working environment.
     */
    @JvmName("pjsxfvanvcwpmrwe")
    public suspend fun sshPublicKeys(`value`: Output<List<SshPublicKeyArgs>>) {
        this.sshPublicKeys = value
    }

    @JvmName("casnxivvitrjsprk")
    public suspend fun sshPublicKeys(vararg values: Output<SshPublicKeyArgs>) {
        this.sshPublicKeys = Output.all(values.asList())
    }

    /**
     * @param values The SSH configuration for the operating systems that run the nodes in the Kubernetes cluster. In some cases, specification of public keys may be required to produce a working environment.
     */
    @JvmName("kqasmwqugmmvuccf")
    public suspend fun sshPublicKeys(values: List<Output<SshPublicKeyArgs>>) {
        this.sshPublicKeys = Output.all(values)
    }

    /**
     * @param value The user name for the administrator that will be applied to the operating systems that run Kubernetes nodes. If not supplied, a user name will be chosen by the service.
     */
    @JvmName("fsywsmaxndalbwbg")
    public suspend fun adminUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminUsername = mapped
    }

    /**
     * @param value The SSH configuration for the operating systems that run the nodes in the Kubernetes cluster. In some cases, specification of public keys may be required to produce a working environment.
     */
    @JvmName("bayvaeplgkjdjaoo")
    public suspend fun sshPublicKeys(`value`: List<SshPublicKeyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sshPublicKeys = mapped
    }

    /**
     * @param argument The SSH configuration for the operating systems that run the nodes in the Kubernetes cluster. In some cases, specification of public keys may be required to produce a working environment.
     */
    @JvmName("jlcaccfuwqdtxyfe")
    public suspend fun sshPublicKeys(argument: List<suspend SshPublicKeyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SshPublicKeyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sshPublicKeys = mapped
    }

    /**
     * @param argument The SSH configuration for the operating systems that run the nodes in the Kubernetes cluster. In some cases, specification of public keys may be required to produce a working environment.
     */
    @JvmName("epyovnakyeqstwru")
    public suspend fun sshPublicKeys(vararg argument: suspend SshPublicKeyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SshPublicKeyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sshPublicKeys = mapped
    }

    /**
     * @param argument The SSH configuration for the operating systems that run the nodes in the Kubernetes cluster. In some cases, specification of public keys may be required to produce a working environment.
     */
    @JvmName("ycyaslqnbufvvale")
    public suspend fun sshPublicKeys(argument: suspend SshPublicKeyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SshPublicKeyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sshPublicKeys = mapped
    }

    /**
     * @param values The SSH configuration for the operating systems that run the nodes in the Kubernetes cluster. In some cases, specification of public keys may be required to produce a working environment.
     */
    @JvmName("rninugfrowbhwnuh")
    public suspend fun sshPublicKeys(vararg values: SshPublicKeyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sshPublicKeys = mapped
    }

    internal fun build(): AdministratorConfigurationArgs = AdministratorConfigurationArgs(
        adminUsername = adminUsername,
        sshPublicKeys = sshPublicKeys,
    )
}
