@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.AgentOptionsArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.enums.HugepagesSize
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hugepagesCount The number of hugepages to allocate.
 * @property hugepagesSize The size of the hugepages to allocate.
 */
public data class AgentOptionsArgs(
    public val hugepagesCount: Output<Double>,
    public val hugepagesSize: Output<Either<String, HugepagesSize>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.AgentOptionsArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.AgentOptionsArgs =
        com.pulumi.azurenative.networkcloud.inputs.AgentOptionsArgs.builder()
            .hugepagesCount(hugepagesCount.applyValue({ args0 -> args0 }))
            .hugepagesSize(
                hugepagesSize?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [AgentOptionsArgs].
 */
@PulumiTagMarker
public class AgentOptionsArgsBuilder internal constructor() {
    private var hugepagesCount: Output<Double>? = null

    private var hugepagesSize: Output<Either<String, HugepagesSize>>? = null

    /**
     * @param value The number of hugepages to allocate.
     */
    @JvmName("xklavihhtpvmemdo")
    public suspend fun hugepagesCount(`value`: Output<Double>) {
        this.hugepagesCount = value
    }

    /**
     * @param value The size of the hugepages to allocate.
     */
    @JvmName("gkaqjwgckuelqttm")
    public suspend fun hugepagesSize(`value`: Output<Either<String, HugepagesSize>>) {
        this.hugepagesSize = value
    }

    /**
     * @param value The number of hugepages to allocate.
     */
    @JvmName("jwuyigftpdtdpbui")
    public suspend fun hugepagesCount(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hugepagesCount = mapped
    }

    /**
     * @param value The size of the hugepages to allocate.
     */
    @JvmName("iraeqqvspklysjah")
    public suspend fun hugepagesSize(`value`: Either<String, HugepagesSize>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hugepagesSize = mapped
    }

    /**
     * @param value The size of the hugepages to allocate.
     */
    @JvmName("qbiwfrcbvvbhjubu")
    public fun hugepagesSize(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HugepagesSize>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hugepagesSize = mapped
    }

    /**
     * @param value The size of the hugepages to allocate.
     */
    @JvmName("uvodmpcsiepeydvm")
    public fun hugepagesSize(`value`: HugepagesSize) {
        val toBeMapped = Either.ofRight<String, HugepagesSize>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hugepagesSize = mapped
    }

    internal fun build(): AgentOptionsArgs = AgentOptionsArgs(
        hugepagesCount = hugepagesCount ?: throw PulumiNullFieldException("hugepagesCount"),
        hugepagesSize = hugepagesSize,
    )
}
