@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.AgentPoolUpgradeSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maxSurge The maximum number or percentage of nodes that are surged during upgrade. This can either be set to an integer (e.g. '5') or a percentage (e.g. '50%'). If a percentage is specified, it is the percentage of the total agent pool size at the time of the upgrade. For percentages, fractional nodes are rounded up. If not specified, the default is 1.
 */
public data class AgentPoolUpgradeSettingsArgs(
    public val maxSurge: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.AgentPoolUpgradeSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.AgentPoolUpgradeSettingsArgs =
        com.pulumi.azurenative.networkcloud.inputs.AgentPoolUpgradeSettingsArgs.builder()
            .maxSurge(maxSurge?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AgentPoolUpgradeSettingsArgs].
 */
@PulumiTagMarker
public class AgentPoolUpgradeSettingsArgsBuilder internal constructor() {
    private var maxSurge: Output<String>? = null

    /**
     * @param value The maximum number or percentage of nodes that are surged during upgrade. This can either be set to an integer (e.g. '5') or a percentage (e.g. '50%'). If a percentage is specified, it is the percentage of the total agent pool size at the time of the upgrade. For percentages, fractional nodes are rounded up. If not specified, the default is 1.
     */
    @JvmName("mevlxqcltlhcocvx")
    public suspend fun maxSurge(`value`: Output<String>) {
        this.maxSurge = value
    }

    /**
     * @param value The maximum number or percentage of nodes that are surged during upgrade. This can either be set to an integer (e.g. '5') or a percentage (e.g. '50%'). If a percentage is specified, it is the percentage of the total agent pool size at the time of the upgrade. For percentages, fractional nodes are rounded up. If not specified, the default is 1.
     */
    @JvmName("tbbnekggkxxkmoki")
    public suspend fun maxSurge(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxSurge = mapped
    }

    internal fun build(): AgentPoolUpgradeSettingsArgs = AgentPoolUpgradeSettingsArgs(
        maxSurge = maxSurge,
    )
}
