@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.AttachedNetworkConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property l2Networks The list of Layer 2 Networks and related configuration for attachment.
 * @property l3Networks The list of Layer 3 Networks and related configuration for attachment.
 * @property trunkedNetworks The list of Trunked Networks and related configuration for attachment.
 */
public data class AttachedNetworkConfigurationArgs(
    public val l2Networks: Output<List<L2NetworkAttachmentConfigurationArgs>>? = null,
    public val l3Networks: Output<List<L3NetworkAttachmentConfigurationArgs>>? = null,
    public val trunkedNetworks: Output<List<TrunkedNetworkAttachmentConfigurationArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.AttachedNetworkConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.AttachedNetworkConfigurationArgs =
        com.pulumi.azurenative.networkcloud.inputs.AttachedNetworkConfigurationArgs.builder()
            .l2Networks(
                l2Networks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .l3Networks(
                l3Networks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .trunkedNetworks(
                trunkedNetworks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AttachedNetworkConfigurationArgs].
 */
@PulumiTagMarker
public class AttachedNetworkConfigurationArgsBuilder internal constructor() {
    private var l2Networks: Output<List<L2NetworkAttachmentConfigurationArgs>>? = null

    private var l3Networks: Output<List<L3NetworkAttachmentConfigurationArgs>>? = null

    private var trunkedNetworks: Output<List<TrunkedNetworkAttachmentConfigurationArgs>>? = null

    /**
     * @param value The list of Layer 2 Networks and related configuration for attachment.
     */
    @JvmName("mxmmourgulmaoecu")
    public suspend fun l2Networks(`value`: Output<List<L2NetworkAttachmentConfigurationArgs>>) {
        this.l2Networks = value
    }

    @JvmName("hfmhpjqjxnvcgjvg")
    public suspend fun l2Networks(vararg values: Output<L2NetworkAttachmentConfigurationArgs>) {
        this.l2Networks = Output.all(values.asList())
    }

    /**
     * @param values The list of Layer 2 Networks and related configuration for attachment.
     */
    @JvmName("whmrwuvimcehhaqi")
    public suspend fun l2Networks(values: List<Output<L2NetworkAttachmentConfigurationArgs>>) {
        this.l2Networks = Output.all(values)
    }

    /**
     * @param value The list of Layer 3 Networks and related configuration for attachment.
     */
    @JvmName("ancsjpgamduaykow")
    public suspend fun l3Networks(`value`: Output<List<L3NetworkAttachmentConfigurationArgs>>) {
        this.l3Networks = value
    }

    @JvmName("pilbxenjqlmdhxpn")
    public suspend fun l3Networks(vararg values: Output<L3NetworkAttachmentConfigurationArgs>) {
        this.l3Networks = Output.all(values.asList())
    }

    /**
     * @param values The list of Layer 3 Networks and related configuration for attachment.
     */
    @JvmName("ywnjqpbvxrmxkxck")
    public suspend fun l3Networks(values: List<Output<L3NetworkAttachmentConfigurationArgs>>) {
        this.l3Networks = Output.all(values)
    }

    /**
     * @param value The list of Trunked Networks and related configuration for attachment.
     */
    @JvmName("kiwaqnefvdkcrpew")
    public suspend
    fun trunkedNetworks(`value`: Output<List<TrunkedNetworkAttachmentConfigurationArgs>>) {
        this.trunkedNetworks = value
    }

    @JvmName("aistvuvogianrtig")
    public suspend fun trunkedNetworks(
        vararg
        values: Output<TrunkedNetworkAttachmentConfigurationArgs>,
    ) {
        this.trunkedNetworks = Output.all(values.asList())
    }

    /**
     * @param values The list of Trunked Networks and related configuration for attachment.
     */
    @JvmName("dwnogttpyxtgchoa")
    public suspend
    fun trunkedNetworks(values: List<Output<TrunkedNetworkAttachmentConfigurationArgs>>) {
        this.trunkedNetworks = Output.all(values)
    }

    /**
     * @param value The list of Layer 2 Networks and related configuration for attachment.
     */
    @JvmName("pytipwdrhbdptcea")
    public suspend fun l2Networks(`value`: List<L2NetworkAttachmentConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.l2Networks = mapped
    }

    /**
     * @param argument The list of Layer 2 Networks and related configuration for attachment.
     */
    @JvmName("oxkryhhywajlmkne")
    public suspend
    fun l2Networks(argument: List<suspend L2NetworkAttachmentConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            L2NetworkAttachmentConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.l2Networks = mapped
    }

    /**
     * @param argument The list of Layer 2 Networks and related configuration for attachment.
     */
    @JvmName("flbvwyanhqsukphj")
    public suspend fun l2Networks(
        vararg
        argument: suspend L2NetworkAttachmentConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            L2NetworkAttachmentConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.l2Networks = mapped
    }

    /**
     * @param argument The list of Layer 2 Networks and related configuration for attachment.
     */
    @JvmName("ooashnqymfvjdcup")
    public suspend
    fun l2Networks(argument: suspend L2NetworkAttachmentConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            L2NetworkAttachmentConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.l2Networks = mapped
    }

    /**
     * @param values The list of Layer 2 Networks and related configuration for attachment.
     */
    @JvmName("boeemgqaooumxohe")
    public suspend fun l2Networks(vararg values: L2NetworkAttachmentConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.l2Networks = mapped
    }

    /**
     * @param value The list of Layer 3 Networks and related configuration for attachment.
     */
    @JvmName("ggbqlfnlbcccvukg")
    public suspend fun l3Networks(`value`: List<L3NetworkAttachmentConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.l3Networks = mapped
    }

    /**
     * @param argument The list of Layer 3 Networks and related configuration for attachment.
     */
    @JvmName("grrgvybbwamwrmur")
    public suspend
    fun l3Networks(argument: List<suspend L3NetworkAttachmentConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            L3NetworkAttachmentConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.l3Networks = mapped
    }

    /**
     * @param argument The list of Layer 3 Networks and related configuration for attachment.
     */
    @JvmName("oqqdjnhutwfsnbsa")
    public suspend fun l3Networks(
        vararg
        argument: suspend L3NetworkAttachmentConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            L3NetworkAttachmentConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.l3Networks = mapped
    }

    /**
     * @param argument The list of Layer 3 Networks and related configuration for attachment.
     */
    @JvmName("igmmqjfwkmcbhrjm")
    public suspend
    fun l3Networks(argument: suspend L3NetworkAttachmentConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            L3NetworkAttachmentConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.l3Networks = mapped
    }

    /**
     * @param values The list of Layer 3 Networks and related configuration for attachment.
     */
    @JvmName("nbbeahegqkdosrad")
    public suspend fun l3Networks(vararg values: L3NetworkAttachmentConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.l3Networks = mapped
    }

    /**
     * @param value The list of Trunked Networks and related configuration for attachment.
     */
    @JvmName("ucjnnwpuoplqtbll")
    public suspend fun trunkedNetworks(`value`: List<TrunkedNetworkAttachmentConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trunkedNetworks = mapped
    }

    /**
     * @param argument The list of Trunked Networks and related configuration for attachment.
     */
    @JvmName("hderjbowemkabwdo")
    public suspend
    fun trunkedNetworks(argument: List<suspend TrunkedNetworkAttachmentConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TrunkedNetworkAttachmentConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.trunkedNetworks = mapped
    }

    /**
     * @param argument The list of Trunked Networks and related configuration for attachment.
     */
    @JvmName("inqemlsaswacrwrg")
    public suspend fun trunkedNetworks(
        vararg
        argument: suspend TrunkedNetworkAttachmentConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TrunkedNetworkAttachmentConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.trunkedNetworks = mapped
    }

    /**
     * @param argument The list of Trunked Networks and related configuration for attachment.
     */
    @JvmName("nsnujfxwoxcbpkuu")
    public suspend
    fun trunkedNetworks(argument: suspend TrunkedNetworkAttachmentConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TrunkedNetworkAttachmentConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.trunkedNetworks = mapped
    }

    /**
     * @param values The list of Trunked Networks and related configuration for attachment.
     */
    @JvmName("ibrrwpwjgcixfgqc")
    public suspend fun trunkedNetworks(vararg values: TrunkedNetworkAttachmentConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trunkedNetworks = mapped
    }

    internal fun build(): AttachedNetworkConfigurationArgs = AttachedNetworkConfigurationArgs(
        l2Networks = l2Networks,
        l3Networks = l3Networks,
        trunkedNetworks = trunkedNetworks,
    )
}
