@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.BgpServiceLoadBalancerConfigurationArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.enums.FabricPeeringEnabled
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property bgpAdvertisements The association of IP address pools to the communities and peers, allowing for announcement of IPs.
 * @property bgpPeers The list of additional BgpPeer entities that the Kubernetes cluster will peer with. All peering must be explicitly defined.
 * @property fabricPeeringEnabled The indicator to specify if the load balancer peers with the network fabric.
 * @property ipAddressPools The list of pools of IP addresses that can be allocated to Load Balancer services.
 */
public data class BgpServiceLoadBalancerConfigurationArgs(
    public val bgpAdvertisements: Output<List<BgpAdvertisementArgs>>? = null,
    public val bgpPeers: Output<List<ServiceLoadBalancerBgpPeerArgs>>? = null,
    public val fabricPeeringEnabled: Output<Either<String, FabricPeeringEnabled>>? = null,
    public val ipAddressPools: Output<List<IpAddressPoolArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.BgpServiceLoadBalancerConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.networkcloud.inputs.BgpServiceLoadBalancerConfigurationArgs =
        com.pulumi.azurenative.networkcloud.inputs.BgpServiceLoadBalancerConfigurationArgs.builder()
            .bgpAdvertisements(
                bgpAdvertisements?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .bgpPeers(
                bgpPeers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .fabricPeeringEnabled(
                fabricPeeringEnabled?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .ipAddressPools(
                ipAddressPools?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [BgpServiceLoadBalancerConfigurationArgs].
 */
@PulumiTagMarker
public class BgpServiceLoadBalancerConfigurationArgsBuilder internal constructor() {
    private var bgpAdvertisements: Output<List<BgpAdvertisementArgs>>? = null

    private var bgpPeers: Output<List<ServiceLoadBalancerBgpPeerArgs>>? = null

    private var fabricPeeringEnabled: Output<Either<String, FabricPeeringEnabled>>? = null

    private var ipAddressPools: Output<List<IpAddressPoolArgs>>? = null

    /**
     * @param value The association of IP address pools to the communities and peers, allowing for announcement of IPs.
     */
    @JvmName("ihweomudoupgsnwo")
    public suspend fun bgpAdvertisements(`value`: Output<List<BgpAdvertisementArgs>>) {
        this.bgpAdvertisements = value
    }

    @JvmName("cfamwlpvuvdkyikd")
    public suspend fun bgpAdvertisements(vararg values: Output<BgpAdvertisementArgs>) {
        this.bgpAdvertisements = Output.all(values.asList())
    }

    /**
     * @param values The association of IP address pools to the communities and peers, allowing for announcement of IPs.
     */
    @JvmName("buryskwtjcrckaar")
    public suspend fun bgpAdvertisements(values: List<Output<BgpAdvertisementArgs>>) {
        this.bgpAdvertisements = Output.all(values)
    }

    /**
     * @param value The list of additional BgpPeer entities that the Kubernetes cluster will peer with. All peering must be explicitly defined.
     */
    @JvmName("udfqbcgjubjuqpyp")
    public suspend fun bgpPeers(`value`: Output<List<ServiceLoadBalancerBgpPeerArgs>>) {
        this.bgpPeers = value
    }

    @JvmName("vsslixbadrtrghli")
    public suspend fun bgpPeers(vararg values: Output<ServiceLoadBalancerBgpPeerArgs>) {
        this.bgpPeers = Output.all(values.asList())
    }

    /**
     * @param values The list of additional BgpPeer entities that the Kubernetes cluster will peer with. All peering must be explicitly defined.
     */
    @JvmName("duyqtjcirifmqugw")
    public suspend fun bgpPeers(values: List<Output<ServiceLoadBalancerBgpPeerArgs>>) {
        this.bgpPeers = Output.all(values)
    }

    /**
     * @param value The indicator to specify if the load balancer peers with the network fabric.
     */
    @JvmName("iegnbjgipjuubypr")
    public suspend fun fabricPeeringEnabled(`value`: Output<Either<String, FabricPeeringEnabled>>) {
        this.fabricPeeringEnabled = value
    }

    /**
     * @param value The list of pools of IP addresses that can be allocated to Load Balancer services.
     */
    @JvmName("pewgofxfjmhplvud")
    public suspend fun ipAddressPools(`value`: Output<List<IpAddressPoolArgs>>) {
        this.ipAddressPools = value
    }

    @JvmName("rhxcgyvlmpyndtyk")
    public suspend fun ipAddressPools(vararg values: Output<IpAddressPoolArgs>) {
        this.ipAddressPools = Output.all(values.asList())
    }

    /**
     * @param values The list of pools of IP addresses that can be allocated to Load Balancer services.
     */
    @JvmName("qoihpwbyeuhsiqdc")
    public suspend fun ipAddressPools(values: List<Output<IpAddressPoolArgs>>) {
        this.ipAddressPools = Output.all(values)
    }

    /**
     * @param value The association of IP address pools to the communities and peers, allowing for announcement of IPs.
     */
    @JvmName("nfudahfjmjutcyve")
    public suspend fun bgpAdvertisements(`value`: List<BgpAdvertisementArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpAdvertisements = mapped
    }

    /**
     * @param argument The association of IP address pools to the communities and peers, allowing for announcement of IPs.
     */
    @JvmName("fvudijtjnyoftdhe")
    public suspend
    fun bgpAdvertisements(argument: List<suspend BgpAdvertisementArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BgpAdvertisementArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.bgpAdvertisements = mapped
    }

    /**
     * @param argument The association of IP address pools to the communities and peers, allowing for announcement of IPs.
     */
    @JvmName("iimekrqssggtoxns")
    public suspend fun bgpAdvertisements(
        vararg
        argument: suspend BgpAdvertisementArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BgpAdvertisementArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.bgpAdvertisements = mapped
    }

    /**
     * @param argument The association of IP address pools to the communities and peers, allowing for announcement of IPs.
     */
    @JvmName("owqpkltfgbgeabsa")
    public suspend fun bgpAdvertisements(argument: suspend BgpAdvertisementArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BgpAdvertisementArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.bgpAdvertisements = mapped
    }

    /**
     * @param values The association of IP address pools to the communities and peers, allowing for announcement of IPs.
     */
    @JvmName("asuquoxbyilycenl")
    public suspend fun bgpAdvertisements(vararg values: BgpAdvertisementArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bgpAdvertisements = mapped
    }

    /**
     * @param value The list of additional BgpPeer entities that the Kubernetes cluster will peer with. All peering must be explicitly defined.
     */
    @JvmName("koprmarwxpcditec")
    public suspend fun bgpPeers(`value`: List<ServiceLoadBalancerBgpPeerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpPeers = mapped
    }

    /**
     * @param argument The list of additional BgpPeer entities that the Kubernetes cluster will peer with. All peering must be explicitly defined.
     */
    @JvmName("ptshrcidnnseiinw")
    public suspend
    fun bgpPeers(argument: List<suspend ServiceLoadBalancerBgpPeerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceLoadBalancerBgpPeerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.bgpPeers = mapped
    }

    /**
     * @param argument The list of additional BgpPeer entities that the Kubernetes cluster will peer with. All peering must be explicitly defined.
     */
    @JvmName("cjpfpattdokldhrs")
    public suspend fun bgpPeers(
        vararg
        argument: suspend ServiceLoadBalancerBgpPeerArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ServiceLoadBalancerBgpPeerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.bgpPeers = mapped
    }

    /**
     * @param argument The list of additional BgpPeer entities that the Kubernetes cluster will peer with. All peering must be explicitly defined.
     */
    @JvmName("uurkwsfjofigvwta")
    public suspend fun bgpPeers(argument: suspend ServiceLoadBalancerBgpPeerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ServiceLoadBalancerBgpPeerArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.bgpPeers = mapped
    }

    /**
     * @param values The list of additional BgpPeer entities that the Kubernetes cluster will peer with. All peering must be explicitly defined.
     */
    @JvmName("anclsjylmsvlrkke")
    public suspend fun bgpPeers(vararg values: ServiceLoadBalancerBgpPeerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bgpPeers = mapped
    }

    /**
     * @param value The indicator to specify if the load balancer peers with the network fabric.
     */
    @JvmName("ppsfuyxxrabmgrtb")
    public suspend fun fabricPeeringEnabled(`value`: Either<String, FabricPeeringEnabled>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fabricPeeringEnabled = mapped
    }

    /**
     * @param value The indicator to specify if the load balancer peers with the network fabric.
     */
    @JvmName("weyskontulslcyfm")
    public fun fabricPeeringEnabled(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FabricPeeringEnabled>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fabricPeeringEnabled = mapped
    }

    /**
     * @param value The indicator to specify if the load balancer peers with the network fabric.
     */
    @JvmName("cfanacmbjcuejkfo")
    public fun fabricPeeringEnabled(`value`: FabricPeeringEnabled) {
        val toBeMapped = Either.ofRight<String, FabricPeeringEnabled>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fabricPeeringEnabled = mapped
    }

    /**
     * @param value The list of pools of IP addresses that can be allocated to Load Balancer services.
     */
    @JvmName("gbqbkqqpbqcqwanl")
    public suspend fun ipAddressPools(`value`: List<IpAddressPoolArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddressPools = mapped
    }

    /**
     * @param argument The list of pools of IP addresses that can be allocated to Load Balancer services.
     */
    @JvmName("tgpvylesfdkytnvp")
    public suspend fun ipAddressPools(argument: List<suspend IpAddressPoolArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IpAddressPoolArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipAddressPools = mapped
    }

    /**
     * @param argument The list of pools of IP addresses that can be allocated to Load Balancer services.
     */
    @JvmName("mxptdphgdgbphxrj")
    public suspend fun ipAddressPools(vararg argument: suspend IpAddressPoolArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            IpAddressPoolArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipAddressPools = mapped
    }

    /**
     * @param argument The list of pools of IP addresses that can be allocated to Load Balancer services.
     */
    @JvmName("mfigiaekmtatbkde")
    public suspend fun ipAddressPools(argument: suspend IpAddressPoolArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpAddressPoolArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipAddressPools = mapped
    }

    /**
     * @param values The list of pools of IP addresses that can be allocated to Load Balancer services.
     */
    @JvmName("npesdsggcpicxpxc")
    public suspend fun ipAddressPools(vararg values: IpAddressPoolArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAddressPools = mapped
    }

    internal fun build(): BgpServiceLoadBalancerConfigurationArgs =
        BgpServiceLoadBalancerConfigurationArgs(
            bgpAdvertisements = bgpAdvertisements,
            bgpPeers = bgpPeers,
            fabricPeeringEnabled = fabricPeeringEnabled,
            ipAddressPools = ipAddressPools,
        )
}
