@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.EgressEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property category The descriptive category name of endpoints accessible by the AKS agent node. For example, azure-resource-management, API server, etc. The platform egress endpoints provided by default will use the category 'default'.
 * @property endpoints The list of endpoint dependencies.
 */
public data class EgressEndpointArgs(
    public val category: Output<String>,
    public val endpoints: Output<List<EndpointDependencyArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.EgressEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.EgressEndpointArgs =
        com.pulumi.azurenative.networkcloud.inputs.EgressEndpointArgs.builder()
            .category(category.applyValue({ args0 -> args0 }))
            .endpoints(
                endpoints.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [EgressEndpointArgs].
 */
@PulumiTagMarker
public class EgressEndpointArgsBuilder internal constructor() {
    private var category: Output<String>? = null

    private var endpoints: Output<List<EndpointDependencyArgs>>? = null

    /**
     * @param value The descriptive category name of endpoints accessible by the AKS agent node. For example, azure-resource-management, API server, etc. The platform egress endpoints provided by default will use the category 'default'.
     */
    @JvmName("evgckjclofykusld")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value The list of endpoint dependencies.
     */
    @JvmName("rawgfbhbkxaqqwob")
    public suspend fun endpoints(`value`: Output<List<EndpointDependencyArgs>>) {
        this.endpoints = value
    }

    @JvmName("ppwwvrocqlvqgswx")
    public suspend fun endpoints(vararg values: Output<EndpointDependencyArgs>) {
        this.endpoints = Output.all(values.asList())
    }

    /**
     * @param values The list of endpoint dependencies.
     */
    @JvmName("ejrklbqqqacdxldp")
    public suspend fun endpoints(values: List<Output<EndpointDependencyArgs>>) {
        this.endpoints = Output.all(values)
    }

    /**
     * @param value The descriptive category name of endpoints accessible by the AKS agent node. For example, azure-resource-management, API server, etc. The platform egress endpoints provided by default will use the category 'default'.
     */
    @JvmName("bodjyqolmqfliwqh")
    public suspend fun category(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value The list of endpoint dependencies.
     */
    @JvmName("prvqhyqclofaepfh")
    public suspend fun endpoints(`value`: List<EndpointDependencyArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoints = mapped
    }

    /**
     * @param argument The list of endpoint dependencies.
     */
    @JvmName("rbntwogsknmobpte")
    public suspend fun endpoints(argument: List<suspend EndpointDependencyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EndpointDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param argument The list of endpoint dependencies.
     */
    @JvmName("gjciujbshowhcaqw")
    public suspend fun endpoints(vararg argument: suspend EndpointDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EndpointDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param argument The list of endpoint dependencies.
     */
    @JvmName("gkudtniugfcuaeyc")
    public suspend fun endpoints(argument: suspend EndpointDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EndpointDependencyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param values The list of endpoint dependencies.
     */
    @JvmName("sgxsjequewrqppxw")
    public suspend fun endpoints(vararg values: EndpointDependencyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoints = mapped
    }

    internal fun build(): EgressEndpointArgs = EgressEndpointArgs(
        category = category ?: throw PulumiNullFieldException("category"),
        endpoints = endpoints ?: throw PulumiNullFieldException("endpoints"),
    )
}
