@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.EndpointDependencyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property domainName The domain name of the dependency.
 * @property port The port of this endpoint.
 */
public data class EndpointDependencyArgs(
    public val domainName: Output<String>,
    public val port: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.EndpointDependencyArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.EndpointDependencyArgs =
        com.pulumi.azurenative.networkcloud.inputs.EndpointDependencyArgs.builder()
            .domainName(domainName.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointDependencyArgs].
 */
@PulumiTagMarker
public class EndpointDependencyArgsBuilder internal constructor() {
    private var domainName: Output<String>? = null

    private var port: Output<Double>? = null

    /**
     * @param value The domain name of the dependency.
     */
    @JvmName("fvlmvvnkhmyqfgig")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value The port of this endpoint.
     */
    @JvmName("tqcxdtplhfifcism")
    public suspend fun port(`value`: Output<Double>) {
        this.port = value
    }

    /**
     * @param value The domain name of the dependency.
     */
    @JvmName("sgmyfkcdmqvefjqu")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value The port of this endpoint.
     */
    @JvmName("bosqbopslmiurcsy")
    public suspend fun port(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    internal fun build(): EndpointDependencyArgs = EndpointDependencyArgs(
        domainName = domainName ?: throw PulumiNullFieldException("domainName"),
        port = port,
    )
}
