@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.GetBareMetalMachinePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bareMetalMachineName The name of the bare metal machine.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetBareMetalMachinePlainArgs(
    public val bareMetalMachineName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.GetBareMetalMachinePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.GetBareMetalMachinePlainArgs =
        com.pulumi.azurenative.networkcloud.inputs.GetBareMetalMachinePlainArgs.builder()
            .bareMetalMachineName(bareMetalMachineName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBareMetalMachinePlainArgs].
 */
@PulumiTagMarker
public class GetBareMetalMachinePlainArgsBuilder internal constructor() {
    private var bareMetalMachineName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the bare metal machine.
     */
    @JvmName("kwowcwcqipqurxtm")
    public suspend fun bareMetalMachineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.bareMetalMachineName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fegviamukrrfbywe")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetBareMetalMachinePlainArgs = GetBareMetalMachinePlainArgs(
        bareMetalMachineName = bareMetalMachineName ?: throw
            PulumiNullFieldException("bareMetalMachineName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
