@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.GetCloudServicesNetworkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cloudServicesNetworkName The name of the cloud services network.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetCloudServicesNetworkPlainArgs(
    public val cloudServicesNetworkName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.GetCloudServicesNetworkPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.GetCloudServicesNetworkPlainArgs =
        com.pulumi.azurenative.networkcloud.inputs.GetCloudServicesNetworkPlainArgs.builder()
            .cloudServicesNetworkName(cloudServicesNetworkName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCloudServicesNetworkPlainArgs].
 */
@PulumiTagMarker
public class GetCloudServicesNetworkPlainArgsBuilder internal constructor() {
    private var cloudServicesNetworkName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the cloud services network.
     */
    @JvmName("emvenjrsbhyrdpfm")
    public suspend fun cloudServicesNetworkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.cloudServicesNetworkName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xmmhjmjyobxfgfts")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCloudServicesNetworkPlainArgs = GetCloudServicesNetworkPlainArgs(
        cloudServicesNetworkName = cloudServicesNetworkName ?: throw
            PulumiNullFieldException("cloudServicesNetworkName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
