@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.GetClusterManagerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterManagerName The name of the cluster manager.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetClusterManagerPlainArgs(
    public val clusterManagerName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.GetClusterManagerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.GetClusterManagerPlainArgs =
        com.pulumi.azurenative.networkcloud.inputs.GetClusterManagerPlainArgs.builder()
            .clusterManagerName(clusterManagerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetClusterManagerPlainArgs].
 */
@PulumiTagMarker
public class GetClusterManagerPlainArgsBuilder internal constructor() {
    private var clusterManagerName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the cluster manager.
     */
    @JvmName("doqdpauatcxdvlmd")
    public suspend fun clusterManagerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterManagerName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vtcbpjeiydqljgqw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetClusterManagerPlainArgs = GetClusterManagerPlainArgs(
        clusterManagerName = clusterManagerName ?: throw PulumiNullFieldException("clusterManagerName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
