@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.ManagedResourceGroupConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property location The location of the managed resource group. If not specified, the location of the parent resource is chosen.
 * @property name The name for the managed resource group. If not specified, the unique name is automatically generated.
 */
public data class ManagedResourceGroupConfigurationArgs(
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.ManagedResourceGroupConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.networkcloud.inputs.ManagedResourceGroupConfigurationArgs =
        com.pulumi.azurenative.networkcloud.inputs.ManagedResourceGroupConfigurationArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedResourceGroupConfigurationArgs].
 */
@PulumiTagMarker
public class ManagedResourceGroupConfigurationArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The location of the managed resource group. If not specified, the location of the parent resource is chosen.
     */
    @JvmName("qqxkmxapnmjbdiud")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name for the managed resource group. If not specified, the unique name is automatically generated.
     */
    @JvmName("ycybaifumsdkelpq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The location of the managed resource group. If not specified, the location of the parent resource is chosen.
     */
    @JvmName("orjyqffymkvqyfiw")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name for the managed resource group. If not specified, the unique name is automatically generated.
     */
    @JvmName("kenjnjsajrkgnige")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ManagedResourceGroupConfigurationArgs =
        ManagedResourceGroupConfigurationArgs(
            location = location,
            name = name,
        )
}
