@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.NetworkAttachmentArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.enums.DefaultGateway
import com.pulumi.azurenative.networkcloud.kotlin.enums.VirtualMachineIPAllocationMethod
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property attachedNetworkId The resource ID of the associated network attached to the virtual machine.
 * It can be one of cloudServicesNetwork, l3Network, l2Network or trunkedNetwork resources.
 * @property defaultGateway The indicator of whether this is the default gateway.
 * Only one of the attached networks (including the CloudServicesNetwork attachment) for a single machine may be specified as True.
 * @property ipAllocationMethod The IP allocation mechanism for the virtual machine.
 * Dynamic and Static are only valid for l3Network which may also specify Disabled.
 * Otherwise, Disabled is the only permitted value.
 * @property ipv4Address The IPv4 address of the virtual machine.
 * This field is used only if the attached network has IPAllocationType of IPV4 or DualStack.
 * If IPAllocationMethod is:
 * Static - this field must contain a user specified IPv4 address from within the subnet specified in the attached network.
 * Dynamic - this field is read-only, but will be populated with an address from within the subnet specified in the attached network.
 * Disabled - this field will be empty.
 * @property ipv6Address The IPv6 address of the virtual machine.
 * This field is used only if the attached network has IPAllocationType of IPV6 or DualStack.
 * If IPAllocationMethod is:
 * Static - this field must contain an IPv6 address range from within the range specified in the attached network.
 * Dynamic - this field is read-only, but will be populated with an range from within the subnet specified in the attached network.
 * Disabled - this field will be empty.
 * @property networkAttachmentName The associated network's interface name.
 * If specified, the network attachment name has a maximum length of 15 characters and must be unique to this virtual machine.
 * If the user doesn’t specify this value, the default interface name of the network resource will be used.
 * For a CloudServicesNetwork resource, this name will be ignored.
 */
public data class NetworkAttachmentArgs(
    public val attachedNetworkId: Output<String>,
    public val defaultGateway: Output<Either<String, DefaultGateway>>? = null,
    public val ipAllocationMethod: Output<Either<String, VirtualMachineIPAllocationMethod>>,
    public val ipv4Address: Output<String>? = null,
    public val ipv6Address: Output<String>? = null,
    public val networkAttachmentName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.NetworkAttachmentArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.NetworkAttachmentArgs =
        com.pulumi.azurenative.networkcloud.inputs.NetworkAttachmentArgs.builder()
            .attachedNetworkId(attachedNetworkId.applyValue({ args0 -> args0 }))
            .defaultGateway(
                defaultGateway?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ipAllocationMethod(
                ipAllocationMethod.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .ipv4Address(ipv4Address?.applyValue({ args0 -> args0 }))
            .ipv6Address(ipv6Address?.applyValue({ args0 -> args0 }))
            .networkAttachmentName(networkAttachmentName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkAttachmentArgs].
 */
@PulumiTagMarker
public class NetworkAttachmentArgsBuilder internal constructor() {
    private var attachedNetworkId: Output<String>? = null

    private var defaultGateway: Output<Either<String, DefaultGateway>>? = null

    private var ipAllocationMethod: Output<Either<String, VirtualMachineIPAllocationMethod>>? = null

    private var ipv4Address: Output<String>? = null

    private var ipv6Address: Output<String>? = null

    private var networkAttachmentName: Output<String>? = null

    /**
     * @param value The resource ID of the associated network attached to the virtual machine.
     * It can be one of cloudServicesNetwork, l3Network, l2Network or trunkedNetwork resources.
     */
    @JvmName("ktniyxwnwoxsbfgx")
    public suspend fun attachedNetworkId(`value`: Output<String>) {
        this.attachedNetworkId = value
    }

    /**
     * @param value The indicator of whether this is the default gateway.
     * Only one of the attached networks (including the CloudServicesNetwork attachment) for a single machine may be specified as True.
     */
    @JvmName("hicrsnefhctkfekr")
    public suspend fun defaultGateway(`value`: Output<Either<String, DefaultGateway>>) {
        this.defaultGateway = value
    }

    /**
     * @param value The IP allocation mechanism for the virtual machine.
     * Dynamic and Static are only valid for l3Network which may also specify Disabled.
     * Otherwise, Disabled is the only permitted value.
     */
    @JvmName("lugilximcrmgrlrs")
    public suspend
    fun ipAllocationMethod(`value`: Output<Either<String, VirtualMachineIPAllocationMethod>>) {
        this.ipAllocationMethod = value
    }

    /**
     * @param value The IPv4 address of the virtual machine.
     * This field is used only if the attached network has IPAllocationType of IPV4 or DualStack.
     * If IPAllocationMethod is:
     * Static - this field must contain a user specified IPv4 address from within the subnet specified in the attached network.
     * Dynamic - this field is read-only, but will be populated with an address from within the subnet specified in the attached network.
     * Disabled - this field will be empty.
     */
    @JvmName("emgytvetuvlwovug")
    public suspend fun ipv4Address(`value`: Output<String>) {
        this.ipv4Address = value
    }

    /**
     * @param value The IPv6 address of the virtual machine.
     * This field is used only if the attached network has IPAllocationType of IPV6 or DualStack.
     * If IPAllocationMethod is:
     * Static - this field must contain an IPv6 address range from within the range specified in the attached network.
     * Dynamic - this field is read-only, but will be populated with an range from within the subnet specified in the attached network.
     * Disabled - this field will be empty.
     */
    @JvmName("beffjspyphjvqdyw")
    public suspend fun ipv6Address(`value`: Output<String>) {
        this.ipv6Address = value
    }

    /**
     * @param value The associated network's interface name.
     * If specified, the network attachment name has a maximum length of 15 characters and must be unique to this virtual machine.
     * If the user doesn’t specify this value, the default interface name of the network resource will be used.
     * For a CloudServicesNetwork resource, this name will be ignored.
     */
    @JvmName("kidlcxwsegmcmnpe")
    public suspend fun networkAttachmentName(`value`: Output<String>) {
        this.networkAttachmentName = value
    }

    /**
     * @param value The resource ID of the associated network attached to the virtual machine.
     * It can be one of cloudServicesNetwork, l3Network, l2Network or trunkedNetwork resources.
     */
    @JvmName("pgelrqrnhgakmifg")
    public suspend fun attachedNetworkId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attachedNetworkId = mapped
    }

    /**
     * @param value The indicator of whether this is the default gateway.
     * Only one of the attached networks (including the CloudServicesNetwork attachment) for a single machine may be specified as True.
     */
    @JvmName("rfiswngcvteiyfrc")
    public suspend fun defaultGateway(`value`: Either<String, DefaultGateway>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultGateway = mapped
    }

    /**
     * @param value The indicator of whether this is the default gateway.
     * Only one of the attached networks (including the CloudServicesNetwork attachment) for a single machine may be specified as True.
     */
    @JvmName("uksbtvkkpjtwcbqg")
    public fun defaultGateway(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DefaultGateway>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultGateway = mapped
    }

    /**
     * @param value The indicator of whether this is the default gateway.
     * Only one of the attached networks (including the CloudServicesNetwork attachment) for a single machine may be specified as True.
     */
    @JvmName("bpijbcuntskxrswo")
    public fun defaultGateway(`value`: DefaultGateway) {
        val toBeMapped = Either.ofRight<String, DefaultGateway>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultGateway = mapped
    }

    /**
     * @param value The IP allocation mechanism for the virtual machine.
     * Dynamic and Static are only valid for l3Network which may also specify Disabled.
     * Otherwise, Disabled is the only permitted value.
     */
    @JvmName("qmkgxbrvefunfjog")
    public suspend fun ipAllocationMethod(`value`: Either<String, VirtualMachineIPAllocationMethod>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAllocationMethod = mapped
    }

    /**
     * @param value The IP allocation mechanism for the virtual machine.
     * Dynamic and Static are only valid for l3Network which may also specify Disabled.
     * Otherwise, Disabled is the only permitted value.
     */
    @JvmName("gkogxingnmyvlpea")
    public fun ipAllocationMethod(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualMachineIPAllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAllocationMethod = mapped
    }

    /**
     * @param value The IP allocation mechanism for the virtual machine.
     * Dynamic and Static are only valid for l3Network which may also specify Disabled.
     * Otherwise, Disabled is the only permitted value.
     */
    @JvmName("ouqdrqbqcmoendbp")
    public fun ipAllocationMethod(`value`: VirtualMachineIPAllocationMethod) {
        val toBeMapped = Either.ofRight<String, VirtualMachineIPAllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAllocationMethod = mapped
    }

    /**
     * @param value The IPv4 address of the virtual machine.
     * This field is used only if the attached network has IPAllocationType of IPV4 or DualStack.
     * If IPAllocationMethod is:
     * Static - this field must contain a user specified IPv4 address from within the subnet specified in the attached network.
     * Dynamic - this field is read-only, but will be populated with an address from within the subnet specified in the attached network.
     * Disabled - this field will be empty.
     */
    @JvmName("ixkbmushwhtswune")
    public suspend fun ipv4Address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4Address = mapped
    }

    /**
     * @param value The IPv6 address of the virtual machine.
     * This field is used only if the attached network has IPAllocationType of IPV6 or DualStack.
     * If IPAllocationMethod is:
     * Static - this field must contain an IPv6 address range from within the range specified in the attached network.
     * Dynamic - this field is read-only, but will be populated with an range from within the subnet specified in the attached network.
     * Disabled - this field will be empty.
     */
    @JvmName("fcbbbkehpvgjecqn")
    public suspend fun ipv6Address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6Address = mapped
    }

    /**
     * @param value The associated network's interface name.
     * If specified, the network attachment name has a maximum length of 15 characters and must be unique to this virtual machine.
     * If the user doesn’t specify this value, the default interface name of the network resource will be used.
     * For a CloudServicesNetwork resource, this name will be ignored.
     */
    @JvmName("vxtmgkgbdxkhyrvf")
    public suspend fun networkAttachmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkAttachmentName = mapped
    }

    internal fun build(): NetworkAttachmentArgs = NetworkAttachmentArgs(
        attachedNetworkId = attachedNetworkId ?: throw PulumiNullFieldException("attachedNetworkId"),
        defaultGateway = defaultGateway,
        ipAllocationMethod = ipAllocationMethod ?: throw PulumiNullFieldException("ipAllocationMethod"),
        ipv4Address = ipv4Address,
        ipv6Address = ipv6Address,
        networkAttachmentName = networkAttachmentName,
    )
}
