@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.ServicePrincipalInformationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationId The application ID, also known as client ID, of the service principal.
 * @property password The password of the service principal.
 * @property principalId The principal ID, also known as the object ID, of the service principal.
 * @property tenantId The tenant ID, also known as the directory ID, of the tenant in which the service principal is created.
 */
public data class ServicePrincipalInformationArgs(
    public val applicationId: Output<String>,
    public val password: Output<String>,
    public val principalId: Output<String>,
    public val tenantId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.ServicePrincipalInformationArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.ServicePrincipalInformationArgs =
        com.pulumi.azurenative.networkcloud.inputs.ServicePrincipalInformationArgs.builder()
            .applicationId(applicationId.applyValue({ args0 -> args0 }))
            .password(password.applyValue({ args0 -> args0 }))
            .principalId(principalId.applyValue({ args0 -> args0 }))
            .tenantId(tenantId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServicePrincipalInformationArgs].
 */
@PulumiTagMarker
public class ServicePrincipalInformationArgsBuilder internal constructor() {
    private var applicationId: Output<String>? = null

    private var password: Output<String>? = null

    private var principalId: Output<String>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value The application ID, also known as client ID, of the service principal.
     */
    @JvmName("nyrtypttnwqmrrok")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value The password of the service principal.
     */
    @JvmName("noeugrbvypumuwnl")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The principal ID, also known as the object ID, of the service principal.
     */
    @JvmName("ftxpiiayojppjqvh")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value The tenant ID, also known as the directory ID, of the tenant in which the service principal is created.
     */
    @JvmName("heslktvkgbauuflo")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value The application ID, also known as client ID, of the service principal.
     */
    @JvmName("jbsyfkkmrpuatgdt")
    public suspend fun applicationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value The password of the service principal.
     */
    @JvmName("rwcdshuowfyibkwh")
    public suspend fun password(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The principal ID, also known as the object ID, of the service principal.
     */
    @JvmName("nagsyhjlnlrtxnmg")
    public suspend fun principalId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    /**
     * @param value The tenant ID, also known as the directory ID, of the tenant in which the service principal is created.
     */
    @JvmName("boqyrdowqddcooqc")
    public suspend fun tenantId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): ServicePrincipalInformationArgs = ServicePrincipalInformationArgs(
        applicationId = applicationId ?: throw PulumiNullFieldException("applicationId"),
        password = password ?: throw PulumiNullFieldException("password"),
        principalId = principalId ?: throw PulumiNullFieldException("principalId"),
        tenantId = tenantId ?: throw PulumiNullFieldException("tenantId"),
    )
}
