@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property advertiseToFabric The indicator of if this advertisement is also made to the network fabric associated with the Network Cloud Cluster. This field is ignored if fabricPeeringEnabled is set to False.
 * @property communities The names of the BGP communities to be associated with the announcement, utilizing a BGP community string in 1234:1234 format.
 * @property ipAddressPools The names of the IP address pools associated with this announcement.
 * @property peers The names of the BGP peers to limit this advertisement to. If no values are specified, all BGP peers will receive this advertisement.
 */
public data class BgpAdvertisementResponse(
    public val advertiseToFabric: String? = null,
    public val communities: List<String>? = null,
    public val ipAddressPools: List<String>,
    public val peers: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.BgpAdvertisementResponse):
            BgpAdvertisementResponse = BgpAdvertisementResponse(
            advertiseToFabric = javaType.advertiseToFabric().map({ args0 -> args0 }).orElse(null),
            communities = javaType.communities().map({ args0 -> args0 }),
            ipAddressPools = javaType.ipAddressPools().map({ args0 -> args0 }),
            peers = javaType.peers().map({ args0 -> args0 }),
        )
    }
}
