@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property applicationId The application ID, also known as client ID, of the service principal.
 * @property password The password of the service principal.
 * @property principalId The principal ID, also known as the object ID, of the service principal.
 * @property tenantId The tenant ID, also known as the directory ID, of the tenant in which the service principal is created.
 */
public data class ServicePrincipalInformationResponse(
    public val applicationId: String,
    public val password: String,
    public val principalId: String,
    public val tenantId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.ServicePrincipalInformationResponse):
            ServicePrincipalInformationResponse = ServicePrincipalInformationResponse(
            applicationId = javaType.applicationId(),
            password = javaType.password(),
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
        )
    }
}
