@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkfunction.kotlin

import com.pulumi.azurenative.networkfunction.CollectorPolicyArgs.builder
import com.pulumi.azurenative.networkfunction.kotlin.inputs.EmissionPoliciesPropertiesFormatArgs
import com.pulumi.azurenative.networkfunction.kotlin.inputs.EmissionPoliciesPropertiesFormatArgsBuilder
import com.pulumi.azurenative.networkfunction.kotlin.inputs.IngestionPolicyPropertiesFormatArgs
import com.pulumi.azurenative.networkfunction.kotlin.inputs.IngestionPolicyPropertiesFormatArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Collector policy resource.
 * Azure REST API version: 2022-11-01. Prior API version in Azure Native 1.x: 2022-05-01.
 * Other available API versions: 2022-05-01.
 * ## Example Usage
 * ### Create a collection policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var collectorPolicy = new AzureNative.NetworkFunction.CollectorPolicy("collectorPolicy", new()
 *     {
 *         AzureTrafficCollectorName = "atc",
 *         CollectorPolicyName = "cp1",
 *         EmissionPolicies = new[]
 *         {
 *             new AzureNative.NetworkFunction.Inputs.EmissionPoliciesPropertiesFormatArgs
 *             {
 *                 EmissionDestinations = new[]
 *                 {
 *                     new AzureNative.NetworkFunction.Inputs.EmissionPolicyDestinationArgs
 *                     {
 *                         DestinationType = "AzureMonitor",
 *                     },
 *                 },
 *                 EmissionType = "IPFIX",
 *             },
 *         },
 *         IngestionPolicy = new AzureNative.NetworkFunction.Inputs.IngestionPolicyPropertiesFormatArgs
 *         {
 *             IngestionSources = new[]
 *             {
 *                 new AzureNative.NetworkFunction.Inputs.IngestionSourcesPropertiesFormatArgs
 *                 {
 *                     ResourceId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRouteCircuits/circuitName",
 *                     SourceType = "Resource",
 *                 },
 *             },
 *             IngestionType = "IPFIX",
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkfunction/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkfunction.NewCollectorPolicy(ctx, "collectorPolicy", &networkfunction.CollectorPolicyArgs{
 * 			AzureTrafficCollectorName: pulumi.String("atc"),
 * 			CollectorPolicyName:       pulumi.String("cp1"),
 * 			EmissionPolicies: []networkfunction.EmissionPoliciesPropertiesFormatArgs{
 * 				{
 * 					EmissionDestinations: networkfunction.EmissionPolicyDestinationArray{
 * 						{
 * 							DestinationType: pulumi.String("AzureMonitor"),
 * 						},
 * 					},
 * 					EmissionType: pulumi.String("IPFIX"),
 * 				},
 * 			},
 * 			IngestionPolicy: networkfunction.IngestionPolicyPropertiesFormatResponse{
 * 				IngestionSources: networkfunction.IngestionSourcesPropertiesFormatArray{
 * 					&networkfunction.IngestionSourcesPropertiesFormatArgs{
 * 						ResourceId: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRouteCircuits/circuitName"),
 * 						SourceType: pulumi.String("Resource"),
 * 					},
 * 				},
 * 				IngestionType: pulumi.String("IPFIX"),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkfunction.CollectorPolicy;
 * import com.pulumi.azurenative.networkfunction.CollectorPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var collectorPolicy = new CollectorPolicy("collectorPolicy", CollectorPolicyArgs.builder()
 *             .azureTrafficCollectorName("atc")
 *             .collectorPolicyName("cp1")
 *             .emissionPolicies(Map.ofEntries(
 *                 Map.entry("emissionDestinations", Map.of("destinationType", "AzureMonitor")),
 *                 Map.entry("emissionType", "IPFIX")
 *             ))
 *             .ingestionPolicy(Map.ofEntries(
 *                 Map.entry("ingestionSources", Map.ofEntries(
 *                     Map.entry("resourceId", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRouteCircuits/circuitName"),
 *                     Map.entry("sourceType", "Resource")
 *                 )),
 *                 Map.entry("ingestionType", "IPFIX")
 *             ))
 *             .location("West US")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkfunction:CollectorPolicy cp1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkFunction/azureTrafficCollectors/{azureTrafficCollectorName}/collectorPolicies/{collectorPolicyName}
 * ```
 * @property azureTrafficCollectorName Azure Traffic Collector name
 * @property collectorPolicyName Collector Policy Name
 * @property emissionPolicies Emission policies.
 * @property ingestionPolicy Ingestion policies.
 * @property location Resource location.
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags.
 */
public data class CollectorPolicyArgs(
    public val azureTrafficCollectorName: Output<String>? = null,
    public val collectorPolicyName: Output<String>? = null,
    public val emissionPolicies: Output<List<EmissionPoliciesPropertiesFormatArgs>>? = null,
    public val ingestionPolicy: Output<IngestionPolicyPropertiesFormatArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkfunction.CollectorPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.networkfunction.CollectorPolicyArgs =
        com.pulumi.azurenative.networkfunction.CollectorPolicyArgs.builder()
            .azureTrafficCollectorName(azureTrafficCollectorName?.applyValue({ args0 -> args0 }))
            .collectorPolicyName(collectorPolicyName?.applyValue({ args0 -> args0 }))
            .emissionPolicies(
                emissionPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ingestionPolicy(ingestionPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CollectorPolicyArgs].
 */
@PulumiTagMarker
public class CollectorPolicyArgsBuilder internal constructor() {
    private var azureTrafficCollectorName: Output<String>? = null

    private var collectorPolicyName: Output<String>? = null

    private var emissionPolicies: Output<List<EmissionPoliciesPropertiesFormatArgs>>? = null

    private var ingestionPolicy: Output<IngestionPolicyPropertiesFormatArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Azure Traffic Collector name
     */
    @JvmName("rcqdwgovqeuasobx")
    public suspend fun azureTrafficCollectorName(`value`: Output<String>) {
        this.azureTrafficCollectorName = value
    }

    /**
     * @param value Collector Policy Name
     */
    @JvmName("fetbwoqnlangmnah")
    public suspend fun collectorPolicyName(`value`: Output<String>) {
        this.collectorPolicyName = value
    }

    /**
     * @param value Emission policies.
     */
    @JvmName("fwixbwiytwqteroe")
    public suspend fun emissionPolicies(`value`: Output<List<EmissionPoliciesPropertiesFormatArgs>>) {
        this.emissionPolicies = value
    }

    @JvmName("vmsagowubfplwfmm")
    public suspend fun emissionPolicies(vararg values: Output<EmissionPoliciesPropertiesFormatArgs>) {
        this.emissionPolicies = Output.all(values.asList())
    }

    /**
     * @param values Emission policies.
     */
    @JvmName("xxobcdtlutuqeojo")
    public suspend fun emissionPolicies(values: List<Output<EmissionPoliciesPropertiesFormatArgs>>) {
        this.emissionPolicies = Output.all(values)
    }

    /**
     * @param value Ingestion policies.
     */
    @JvmName("ydmotsayjgvnofdf")
    public suspend fun ingestionPolicy(`value`: Output<IngestionPolicyPropertiesFormatArgs>) {
        this.ingestionPolicy = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("kbybrjavuplfuhca")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("wqdqroagfmywdeef")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("gwngqyodfrmdrcuu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Azure Traffic Collector name
     */
    @JvmName("vlslnrnwubrusqje")
    public suspend fun azureTrafficCollectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureTrafficCollectorName = mapped
    }

    /**
     * @param value Collector Policy Name
     */
    @JvmName("pkakouflgwsiipar")
    public suspend fun collectorPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collectorPolicyName = mapped
    }

    /**
     * @param value Emission policies.
     */
    @JvmName("elnfcucgfvytjsqe")
    public suspend fun emissionPolicies(`value`: List<EmissionPoliciesPropertiesFormatArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emissionPolicies = mapped
    }

    /**
     * @param argument Emission policies.
     */
    @JvmName("docwckifsrnsrxrf")
    public suspend
    fun emissionPolicies(argument: List<suspend EmissionPoliciesPropertiesFormatArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EmissionPoliciesPropertiesFormatArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.emissionPolicies = mapped
    }

    /**
     * @param argument Emission policies.
     */
    @JvmName("ofpwdcoisennwfjq")
    public suspend fun emissionPolicies(
        vararg
        argument: suspend EmissionPoliciesPropertiesFormatArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EmissionPoliciesPropertiesFormatArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.emissionPolicies = mapped
    }

    /**
     * @param argument Emission policies.
     */
    @JvmName("aaewyptxfktdocuk")
    public suspend
    fun emissionPolicies(argument: suspend EmissionPoliciesPropertiesFormatArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EmissionPoliciesPropertiesFormatArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.emissionPolicies = mapped
    }

    /**
     * @param values Emission policies.
     */
    @JvmName("qixnwsfwsolxpflj")
    public suspend fun emissionPolicies(vararg values: EmissionPoliciesPropertiesFormatArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.emissionPolicies = mapped
    }

    /**
     * @param value Ingestion policies.
     */
    @JvmName("wfqnhamjfnejfdbn")
    public suspend fun ingestionPolicy(`value`: IngestionPolicyPropertiesFormatArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingestionPolicy = mapped
    }

    /**
     * @param argument Ingestion policies.
     */
    @JvmName("nttuwhvdclmeygwq")
    public suspend
    fun ingestionPolicy(argument: suspend IngestionPolicyPropertiesFormatArgsBuilder.() -> Unit) {
        val toBeMapped = IngestionPolicyPropertiesFormatArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ingestionPolicy = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("yagcywnibhjlffii")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("fxpnpltsroiyhgac")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("mtendesqgdlbstti")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("otunefoutxkrkdyh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CollectorPolicyArgs = CollectorPolicyArgs(
        azureTrafficCollectorName = azureTrafficCollectorName,
        collectorPolicyName = collectorPolicyName,
        emissionPolicies = emissionPolicies,
        ingestionPolicy = ingestionPolicy,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
