@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkfunction.kotlin.inputs

import com.pulumi.azurenative.networkfunction.inputs.EmissionPolicyDestinationArgs.builder
import com.pulumi.azurenative.networkfunction.kotlin.enums.DestinationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Emission policy destination properties.
 * @property destinationType Emission destination type.
 */
public data class EmissionPolicyDestinationArgs(
    public val destinationType: Output<Either<String, DestinationType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkfunction.inputs.EmissionPolicyDestinationArgs> {
    override fun toJava(): com.pulumi.azurenative.networkfunction.inputs.EmissionPolicyDestinationArgs =
        com.pulumi.azurenative.networkfunction.inputs.EmissionPolicyDestinationArgs.builder()
            .destinationType(
                destinationType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [EmissionPolicyDestinationArgs].
 */
@PulumiTagMarker
public class EmissionPolicyDestinationArgsBuilder internal constructor() {
    private var destinationType: Output<Either<String, DestinationType>>? = null

    /**
     * @param value Emission destination type.
     */
    @JvmName("ifpmfeasblvpakoc")
    public suspend fun destinationType(`value`: Output<Either<String, DestinationType>>) {
        this.destinationType = value
    }

    /**
     * @param value Emission destination type.
     */
    @JvmName("gxxxubvhxsxoneig")
    public suspend fun destinationType(`value`: Either<String, DestinationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationType = mapped
    }

    /**
     * @param value Emission destination type.
     */
    @JvmName("jakafqhcobqtkgbc")
    public fun destinationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DestinationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationType = mapped
    }

    /**
     * @param value Emission destination type.
     */
    @JvmName("pljfotsinoafxemo")
    public fun destinationType(`value`: DestinationType) {
        val toBeMapped = Either.ofRight<String, DestinationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationType = mapped
    }

    internal fun build(): EmissionPolicyDestinationArgs = EmissionPolicyDestinationArgs(
        destinationType = destinationType,
    )
}
