@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkfunction.kotlin.inputs

import com.pulumi.azurenative.networkfunction.inputs.GetCollectorPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property azureTrafficCollectorName Azure Traffic Collector name
 * @property collectorPolicyName Collector Policy Name
 * @property resourceGroupName The name of the resource group.
 */
public data class GetCollectorPolicyPlainArgs(
    public val azureTrafficCollectorName: String,
    public val collectorPolicyName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.networkfunction.inputs.GetCollectorPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.networkfunction.inputs.GetCollectorPolicyPlainArgs =
        com.pulumi.azurenative.networkfunction.inputs.GetCollectorPolicyPlainArgs.builder()
            .azureTrafficCollectorName(azureTrafficCollectorName.let({ args0 -> args0 }))
            .collectorPolicyName(collectorPolicyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCollectorPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetCollectorPolicyPlainArgsBuilder internal constructor() {
    private var azureTrafficCollectorName: String? = null

    private var collectorPolicyName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Azure Traffic Collector name
     */
    @JvmName("jmpmnhahbhltdtmj")
    public suspend fun azureTrafficCollectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.azureTrafficCollectorName = mapped
    }

    /**
     * @param value Collector Policy Name
     */
    @JvmName("gwdkhvwtuivrelcd")
    public suspend fun collectorPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.collectorPolicyName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("pehpikgenppihwfp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCollectorPolicyPlainArgs = GetCollectorPolicyPlainArgs(
        azureTrafficCollectorName = azureTrafficCollectorName ?: throw
            PulumiNullFieldException("azureTrafficCollectorName"),
        collectorPolicyName = collectorPolicyName ?: throw PulumiNullFieldException("collectorPolicyName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
