@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin

import com.pulumi.azurenative.notificationhubs.kotlin.outputs.SharedAccessAuthorizationRulePropertiesResponse
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.SharedAccessAuthorizationRulePropertiesResponse.Companion.toKotlin as sharedAccessAuthorizationRulePropertiesResponseToKotlin
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [NamespaceAuthorizationRule].
 */
@PulumiTagMarker
public class NamespaceAuthorizationRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NamespaceAuthorizationRuleArgs = NamespaceAuthorizationRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NamespaceAuthorizationRuleArgsBuilder.() -> Unit) {
        val builder = NamespaceAuthorizationRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NamespaceAuthorizationRule {
        val builtJavaResource =
            com.pulumi.azurenative.notificationhubs.NamespaceAuthorizationRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NamespaceAuthorizationRule(builtJavaResource)
    }
}

/**
 * Response for POST requests that return single SharedAccessAuthorizationRule.
 * Azure REST API version: 2023-01-01-preview. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2016-03-01, 2017-04-01, 2023-09-01, 2023-10-01-preview.
 * ## Example Usage
 * ### Namespaces_CreateOrUpdateAuthorizationRule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var namespaceAuthorizationRule = new AzureNative.NotificationHubs.NamespaceAuthorizationRule("namespaceAuthorizationRule", new()
 *     {
 *         AuthorizationRuleName = "sdk-AuthRules-1788",
 *         NamespaceName = "nh-sdk-ns",
 *         Properties = new AzureNative.NotificationHubs.Inputs.SharedAccessAuthorizationRulePropertiesArgs
 *         {
 *             Rights = new[]
 *             {
 *                 "Listen",
 *                 "Send",
 *             },
 *         },
 *         ResourceGroupName = "5ktrial",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/notificationhubs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := notificationhubs.NewNamespaceAuthorizationRule(ctx, "namespaceAuthorizationRule", &notificationhubs.NamespaceAuthorizationRuleArgs{
 * 			AuthorizationRuleName: pulumi.String("sdk-AuthRules-1788"),
 * 			NamespaceName:         pulumi.String("nh-sdk-ns"),
 * 			Properties: &notificationhubs.SharedAccessAuthorizationRulePropertiesArgs{
 * 				Rights: pulumi.StringArray{
 * 					pulumi.String("Listen"),
 * 					pulumi.String("Send"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("5ktrial"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.notificationhubs.NamespaceAuthorizationRule;
 * import com.pulumi.azurenative.notificationhubs.NamespaceAuthorizationRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var namespaceAuthorizationRule = new NamespaceAuthorizationRule("namespaceAuthorizationRule", NamespaceAuthorizationRuleArgs.builder()
 *             .authorizationRuleName("sdk-AuthRules-1788")
 *             .namespaceName("nh-sdk-ns")
 *             .properties(Map.of("rights",
 *                 "Listen",
 *                 "Send"))
 *             .resourceGroupName("5ktrial")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:notificationhubs:NamespaceAuthorizationRule NewAuthorizationRule /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/authorizationRules/{authorizationRuleName}
 * ```
 */
public class NamespaceAuthorizationRule internal constructor(
    override val javaResource: com.pulumi.azurenative.notificationhubs.NamespaceAuthorizationRule,
) : KotlinCustomResource(javaResource, NamespaceAuthorizationRuleMapper) {
    /**
     * Deprecated - only for compatibility.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * SharedAccessAuthorizationRule properties.
     */
    public val properties: Output<SharedAccessAuthorizationRulePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                sharedAccessAuthorizationRulePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Deprecated - only for compatibility.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NamespaceAuthorizationRuleMapper : ResourceMapper<NamespaceAuthorizationRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.notificationhubs.NamespaceAuthorizationRule::class == javaResource::class

    override fun map(javaResource: Resource): NamespaceAuthorizationRule =
        NamespaceAuthorizationRule(
            javaResource as
                com.pulumi.azurenative.notificationhubs.NamespaceAuthorizationRule,
        )
}

/**
 * @see [NamespaceAuthorizationRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NamespaceAuthorizationRule].
 */
public suspend fun namespaceAuthorizationRule(
    name: String,
    block: suspend NamespaceAuthorizationRuleResourceBuilder.() -> Unit,
):
    NamespaceAuthorizationRule {
    val builder = NamespaceAuthorizationRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NamespaceAuthorizationRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun namespaceAuthorizationRule(name: String): NamespaceAuthorizationRule {
    val builder = NamespaceAuthorizationRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
