@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.inputs

import com.pulumi.azurenative.notificationhubs.inputs.BaiduCredentialPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Description of a NotificationHub BaiduCredential.
 * @property baiduApiKey Gets or sets baidu Api Key.
 * @property baiduEndPoint Gets or sets baidu Endpoint.
 * @property baiduSecretKey Gets or sets baidu Secret Key
 */
public data class BaiduCredentialPropertiesArgs(
    public val baiduApiKey: Output<String>,
    public val baiduEndPoint: Output<String>,
    public val baiduSecretKey: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.notificationhubs.inputs.BaiduCredentialPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.notificationhubs.inputs.BaiduCredentialPropertiesArgs =
        com.pulumi.azurenative.notificationhubs.inputs.BaiduCredentialPropertiesArgs.builder()
            .baiduApiKey(baiduApiKey.applyValue({ args0 -> args0 }))
            .baiduEndPoint(baiduEndPoint.applyValue({ args0 -> args0 }))
            .baiduSecretKey(baiduSecretKey.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BaiduCredentialPropertiesArgs].
 */
@PulumiTagMarker
public class BaiduCredentialPropertiesArgsBuilder internal constructor() {
    private var baiduApiKey: Output<String>? = null

    private var baiduEndPoint: Output<String>? = null

    private var baiduSecretKey: Output<String>? = null

    /**
     * @param value Gets or sets baidu Api Key.
     */
    @JvmName("qxaxlqabskgvwuqo")
    public suspend fun baiduApiKey(`value`: Output<String>) {
        this.baiduApiKey = value
    }

    /**
     * @param value Gets or sets baidu Endpoint.
     */
    @JvmName("esanvyoyslqiheft")
    public suspend fun baiduEndPoint(`value`: Output<String>) {
        this.baiduEndPoint = value
    }

    /**
     * @param value Gets or sets baidu Secret Key
     */
    @JvmName("skpjakrietvcfurg")
    public suspend fun baiduSecretKey(`value`: Output<String>) {
        this.baiduSecretKey = value
    }

    /**
     * @param value Gets or sets baidu Api Key.
     */
    @JvmName("kiorpprpjwgtrifb")
    public suspend fun baiduApiKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.baiduApiKey = mapped
    }

    /**
     * @param value Gets or sets baidu Endpoint.
     */
    @JvmName("hntssywihlwdoxuf")
    public suspend fun baiduEndPoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.baiduEndPoint = mapped
    }

    /**
     * @param value Gets or sets baidu Secret Key
     */
    @JvmName("wxosatsjpfgcrjvp")
    public suspend fun baiduSecretKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.baiduSecretKey = mapped
    }

    internal fun build(): BaiduCredentialPropertiesArgs = BaiduCredentialPropertiesArgs(
        baiduApiKey = baiduApiKey ?: throw PulumiNullFieldException("baiduApiKey"),
        baiduEndPoint = baiduEndPoint ?: throw PulumiNullFieldException("baiduEndPoint"),
        baiduSecretKey = baiduSecretKey ?: throw PulumiNullFieldException("baiduSecretKey"),
    )
}
