@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.inputs

import com.pulumi.azurenative.notificationhubs.inputs.GcmCredentialPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Description of a NotificationHub GcmCredential.
 * @property gcmEndpoint Gets or sets the GCM endpoint.
 * @property googleApiKey Gets or sets the Google API key.
 */
public data class GcmCredentialPropertiesArgs(
    public val gcmEndpoint: Output<String>? = null,
    public val googleApiKey: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.notificationhubs.inputs.GcmCredentialPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.notificationhubs.inputs.GcmCredentialPropertiesArgs =
        com.pulumi.azurenative.notificationhubs.inputs.GcmCredentialPropertiesArgs.builder()
            .gcmEndpoint(gcmEndpoint?.applyValue({ args0 -> args0 }))
            .googleApiKey(googleApiKey.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GcmCredentialPropertiesArgs].
 */
@PulumiTagMarker
public class GcmCredentialPropertiesArgsBuilder internal constructor() {
    private var gcmEndpoint: Output<String>? = null

    private var googleApiKey: Output<String>? = null

    /**
     * @param value Gets or sets the GCM endpoint.
     */
    @JvmName("deeccgiqgbswkifv")
    public suspend fun gcmEndpoint(`value`: Output<String>) {
        this.gcmEndpoint = value
    }

    /**
     * @param value Gets or sets the Google API key.
     */
    @JvmName("walmdkqsrvwuxhpd")
    public suspend fun googleApiKey(`value`: Output<String>) {
        this.googleApiKey = value
    }

    /**
     * @param value Gets or sets the GCM endpoint.
     */
    @JvmName("jmbkrunkkxiecnjb")
    public suspend fun gcmEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gcmEndpoint = mapped
    }

    /**
     * @param value Gets or sets the Google API key.
     */
    @JvmName("hrqmoafmgvsckfli")
    public suspend fun googleApiKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.googleApiKey = mapped
    }

    internal fun build(): GcmCredentialPropertiesArgs = GcmCredentialPropertiesArgs(
        gcmEndpoint = gcmEndpoint,
        googleApiKey = googleApiKey ?: throw PulumiNullFieldException("googleApiKey"),
    )
}
