@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.inputs

import com.pulumi.azurenative.notificationhubs.inputs.GetNotificationHubPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property namespaceName Namespace name
 * @property notificationHubName Notification Hub name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetNotificationHubPlainArgs(
    public val namespaceName: String,
    public val notificationHubName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.notificationhubs.inputs.GetNotificationHubPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.notificationhubs.inputs.GetNotificationHubPlainArgs =
        com.pulumi.azurenative.notificationhubs.inputs.GetNotificationHubPlainArgs.builder()
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .notificationHubName(notificationHubName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNotificationHubPlainArgs].
 */
@PulumiTagMarker
public class GetNotificationHubPlainArgsBuilder internal constructor() {
    private var namespaceName: String? = null

    private var notificationHubName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Namespace name
     */
    @JvmName("vnwguvwyksmupomt")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value Notification Hub name
     */
    @JvmName("qnssskfhxymoiodq")
    public suspend fun notificationHubName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.notificationHubName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dcoslvgyejoscmqo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNotificationHubPlainArgs = GetNotificationHubPlainArgs(
        namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
        notificationHubName = notificationHubName ?: throw PulumiNullFieldException("notificationHubName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
