@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.inputs

import com.pulumi.azurenative.notificationhubs.inputs.ListNotificationHubKeysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authorizationRuleName Authorization Rule Name
 * @property namespaceName Namespace name
 * @property notificationHubName Notification Hub name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ListNotificationHubKeysPlainArgs(
    public val authorizationRuleName: String,
    public val namespaceName: String,
    public val notificationHubName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.notificationhubs.inputs.ListNotificationHubKeysPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.notificationhubs.inputs.ListNotificationHubKeysPlainArgs =
        com.pulumi.azurenative.notificationhubs.inputs.ListNotificationHubKeysPlainArgs.builder()
            .authorizationRuleName(authorizationRuleName.let({ args0 -> args0 }))
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .notificationHubName(notificationHubName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListNotificationHubKeysPlainArgs].
 */
@PulumiTagMarker
public class ListNotificationHubKeysPlainArgsBuilder internal constructor() {
    private var authorizationRuleName: String? = null

    private var namespaceName: String? = null

    private var notificationHubName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Authorization Rule Name
     */
    @JvmName("vcetqdmnkvqsmcvh")
    public suspend fun authorizationRuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authorizationRuleName = mapped
    }

    /**
     * @param value Namespace name
     */
    @JvmName("kicdglfbqjtmkyyo")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value Notification Hub name
     */
    @JvmName("vqsdyyobbxnqxgbu")
    public suspend fun notificationHubName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.notificationHubName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cdcdjimrncaldtej")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListNotificationHubKeysPlainArgs = ListNotificationHubKeysPlainArgs(
        authorizationRuleName = authorizationRuleName ?: throw
            PulumiNullFieldException("authorizationRuleName"),
        namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
        notificationHubName = notificationHubName ?: throw PulumiNullFieldException("notificationHubName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
