@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.inputs

import com.pulumi.azurenative.notificationhubs.inputs.PublicInternetAuthorizationRuleArgs.builder
import com.pulumi.azurenative.notificationhubs.kotlin.enums.AccessRights
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A default (public Internet) network authorization rule, which contains rights if no other network rule matches.
 * @property rights List of access rights.
 */
public data class PublicInternetAuthorizationRuleArgs(
    public val rights: Output<List<Either<String, AccessRights>>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.notificationhubs.inputs.PublicInternetAuthorizationRuleArgs> {
    override fun toJava():
        com.pulumi.azurenative.notificationhubs.inputs.PublicInternetAuthorizationRuleArgs =
        com.pulumi.azurenative.notificationhubs.inputs.PublicInternetAuthorizationRuleArgs.builder()
            .rights(
                rights.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            ).build()
}

/**
 * Builder for [PublicInternetAuthorizationRuleArgs].
 */
@PulumiTagMarker
public class PublicInternetAuthorizationRuleArgsBuilder internal constructor() {
    private var rights: Output<List<Either<String, AccessRights>>>? = null

    /**
     * @param value List of access rights.
     */
    @JvmName("thhfnugnlyxxnpgs")
    public suspend fun rights(`value`: Output<List<Either<String, AccessRights>>>) {
        this.rights = value
    }

    @JvmName("lvtovosnnejupgth")
    public suspend fun rights(vararg values: Output<Either<String, AccessRights>>) {
        this.rights = Output.all(values.asList())
    }

    /**
     * @param values List of access rights.
     */
    @JvmName("xnpllvstmfolddxv")
    public suspend fun rights(values: List<Output<Either<String, AccessRights>>>) {
        this.rights = Output.all(values)
    }

    /**
     * @param value List of access rights.
     */
    @JvmName("mfxbdkdyweyopbig")
    public suspend fun rights(`value`: List<Either<String, AccessRights>>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rights = mapped
    }

    /**
     * @param values List of access rights.
     */
    @JvmName("ggydjpcwdocopxdr")
    public suspend fun rights(vararg values: Either<String, AccessRights>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rights = mapped
    }

    internal fun build(): PublicInternetAuthorizationRuleArgs = PublicInternetAuthorizationRuleArgs(
        rights = rights ?: throw PulumiNullFieldException("rights"),
    )
}
