@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.inputs

import com.pulumi.azurenative.notificationhubs.inputs.WnsCredentialPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Description of a NotificationHub WnsCredential.
 * @property certificateKey Ges or sets the WNS Certificate Key.
 * @property packageSid Gets or sets the package ID for this credential.
 * @property secretKey Gets or sets the secret key.
 * @property windowsLiveEndpoint Gets or sets the Windows Live endpoint.
 * @property wnsCertificate Gets or sets the WNS Certificate.
 */
public data class WnsCredentialPropertiesArgs(
    public val certificateKey: Output<String>? = null,
    public val packageSid: Output<String>? = null,
    public val secretKey: Output<String>? = null,
    public val windowsLiveEndpoint: Output<String>? = null,
    public val wnsCertificate: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.notificationhubs.inputs.WnsCredentialPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.notificationhubs.inputs.WnsCredentialPropertiesArgs =
        com.pulumi.azurenative.notificationhubs.inputs.WnsCredentialPropertiesArgs.builder()
            .certificateKey(certificateKey?.applyValue({ args0 -> args0 }))
            .packageSid(packageSid?.applyValue({ args0 -> args0 }))
            .secretKey(secretKey?.applyValue({ args0 -> args0 }))
            .windowsLiveEndpoint(windowsLiveEndpoint?.applyValue({ args0 -> args0 }))
            .wnsCertificate(wnsCertificate?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WnsCredentialPropertiesArgs].
 */
@PulumiTagMarker
public class WnsCredentialPropertiesArgsBuilder internal constructor() {
    private var certificateKey: Output<String>? = null

    private var packageSid: Output<String>? = null

    private var secretKey: Output<String>? = null

    private var windowsLiveEndpoint: Output<String>? = null

    private var wnsCertificate: Output<String>? = null

    /**
     * @param value Ges or sets the WNS Certificate Key.
     */
    @JvmName("wptcdlbnwxrtmhqy")
    public suspend fun certificateKey(`value`: Output<String>) {
        this.certificateKey = value
    }

    /**
     * @param value Gets or sets the package ID for this credential.
     */
    @JvmName("woyyfvtufhkkbjwh")
    public suspend fun packageSid(`value`: Output<String>) {
        this.packageSid = value
    }

    /**
     * @param value Gets or sets the secret key.
     */
    @JvmName("gvoxcmjcgxotgbya")
    public suspend fun secretKey(`value`: Output<String>) {
        this.secretKey = value
    }

    /**
     * @param value Gets or sets the Windows Live endpoint.
     */
    @JvmName("gjucssmrtqofdtwg")
    public suspend fun windowsLiveEndpoint(`value`: Output<String>) {
        this.windowsLiveEndpoint = value
    }

    /**
     * @param value Gets or sets the WNS Certificate.
     */
    @JvmName("iokgaflkodgqdhsc")
    public suspend fun wnsCertificate(`value`: Output<String>) {
        this.wnsCertificate = value
    }

    /**
     * @param value Ges or sets the WNS Certificate Key.
     */
    @JvmName("slseodpkhtjhkigi")
    public suspend fun certificateKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateKey = mapped
    }

    /**
     * @param value Gets or sets the package ID for this credential.
     */
    @JvmName("glkqnldpbupwuorh")
    public suspend fun packageSid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageSid = mapped
    }

    /**
     * @param value Gets or sets the secret key.
     */
    @JvmName("ytcyxncjrvmgtfiq")
    public suspend fun secretKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretKey = mapped
    }

    /**
     * @param value Gets or sets the Windows Live endpoint.
     */
    @JvmName("dgpmcmpcpgwtlghk")
    public suspend fun windowsLiveEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.windowsLiveEndpoint = mapped
    }

    /**
     * @param value Gets or sets the WNS Certificate.
     */
    @JvmName("yuvyiyousqnchbdg")
    public suspend fun wnsCertificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wnsCertificate = mapped
    }

    internal fun build(): WnsCredentialPropertiesArgs = WnsCredentialPropertiesArgs(
        certificateKey = certificateKey,
        packageSid = packageSid,
        secretKey = secretKey,
        windowsLiveEndpoint = windowsLiveEndpoint,
        wnsCertificate = wnsCertificate,
    )
}
