@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.inputs

import com.pulumi.azurenative.notificationhubs.inputs.XiaomiCredentialPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Description of a NotificationHub XiaomiCredentialProperties.
 * @property appSecret Gets or sets app secret.
 * @property endpoint Gets or sets xiaomi service endpoint.
 */
public data class XiaomiCredentialPropertiesArgs(
    public val appSecret: Output<String>? = null,
    public val endpoint: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.notificationhubs.inputs.XiaomiCredentialPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.notificationhubs.inputs.XiaomiCredentialPropertiesArgs =
        com.pulumi.azurenative.notificationhubs.inputs.XiaomiCredentialPropertiesArgs.builder()
            .appSecret(appSecret?.applyValue({ args0 -> args0 }))
            .endpoint(endpoint?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [XiaomiCredentialPropertiesArgs].
 */
@PulumiTagMarker
public class XiaomiCredentialPropertiesArgsBuilder internal constructor() {
    private var appSecret: Output<String>? = null

    private var endpoint: Output<String>? = null

    /**
     * @param value Gets or sets app secret.
     */
    @JvmName("tmbpdpujkbeobhjf")
    public suspend fun appSecret(`value`: Output<String>) {
        this.appSecret = value
    }

    /**
     * @param value Gets or sets xiaomi service endpoint.
     */
    @JvmName("qydurjdlqegmtcbd")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value Gets or sets app secret.
     */
    @JvmName("cyosdqfgqroupnfp")
    public suspend fun appSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appSecret = mapped
    }

    /**
     * @param value Gets or sets xiaomi service endpoint.
     */
    @JvmName("vfcirgvniqjddaxt")
    public suspend fun endpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    internal fun build(): XiaomiCredentialPropertiesArgs = XiaomiCredentialPropertiesArgs(
        appSecret = appSecret,
        endpoint = endpoint,
    )
}
