@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Description of a NotificationHub BrowserCredential.
 * @property subject Gets or sets web push subject.
 * @property vapidPrivateKey Gets or sets VAPID private key.
 * @property vapidPublicKey Gets or sets VAPID public key.
 */
public data class BrowserCredentialPropertiesResponse(
    public val subject: String,
    public val vapidPrivateKey: String,
    public val vapidPublicKey: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.notificationhubs.outputs.BrowserCredentialPropertiesResponse):
            BrowserCredentialPropertiesResponse = BrowserCredentialPropertiesResponse(
            subject = javaType.subject(),
            vapidPrivateKey = javaType.vapidPrivateKey(),
            vapidPublicKey = javaType.vapidPublicKey(),
        )
    }
}
