@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A network authorization rule that filters traffic based on IP address.
 * @property ipMask IP mask.
 * @property rights List of access rights.
 */
public data class IpRuleResponse(
    public val ipMask: String,
    public val rights: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.notificationhubs.outputs.IpRuleResponse):
            IpRuleResponse = IpRuleResponse(
            ipMask = javaType.ipMask(),
            rights = javaType.rights().map({ args0 -> args0 }),
        )
    }
}
