@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin

import com.pulumi.azurenative.offazure.kotlin.outputs.SitePropertiesResponse
import com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.offazure.kotlin.outputs.SitePropertiesResponse.Companion.toKotlin as sitePropertiesResponseToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [HyperVSite].
 */
@PulumiTagMarker
public class HyperVSiteResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HyperVSiteArgs = HyperVSiteArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HyperVSiteArgsBuilder.() -> Unit) {
        val builder = HyperVSiteArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): HyperVSite {
        val builtJavaResource = com.pulumi.azurenative.offazure.HyperVSite(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return HyperVSite(builtJavaResource)
    }
}

/**
 * Site REST Resource.
 * Azure REST API version: 2020-07-07. Prior API version in Azure Native 1.x: 2020-01-01.
 * ## Example Usage
 * ### Create Hyper-V site
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hyperVSite = new AzureNative.OffAzure.HyperVSite("hyperVSite", new()
 *     {
 *         Location = "eastus",
 *         Properties = new AzureNative.OffAzure.Inputs.SitePropertiesArgs
 *         {
 *             ServicePrincipalIdentityDetails = new AzureNative.OffAzure.Inputs.SiteSpnPropertiesArgs
 *             {
 *                 AadAuthority = "https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47",
 *                 ApplicationId = "e9f013df-2a2a-4871-b766-e79867f30348",
 *                 Audience = "https://72f988bf-86f1-41af-91ab-2d7cd011db47/MaheshSite17ac9agentauthaadapp",
 *                 ObjectId = "2cd492bc-7ef3-4ee0-b301-59a88108b47b",
 *                 TenantId = "72f988bf-86f1-41af-91ab-2d7cd011db47",
 *             },
 *         },
 *         ResourceGroupName = "pajindTest",
 *         SiteName = "appliance1e39site",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewHyperVSite(ctx, "hyperVSite", &offazure.HyperVSiteArgs{
 * 			Location: pulumi.String("eastus"),
 * 			Properties: offazure.SitePropertiesResponse{
 * 				ServicePrincipalIdentityDetails: &offazure.SiteSpnPropertiesArgs{
 * 					AadAuthority:  pulumi.String("https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 					ApplicationId: pulumi.String("e9f013df-2a2a-4871-b766-e79867f30348"),
 * 					Audience:      pulumi.String("https://72f988bf-86f1-41af-91ab-2d7cd011db47/MaheshSite17ac9agentauthaadapp"),
 * 					ObjectId:      pulumi.String("2cd492bc-7ef3-4ee0-b301-59a88108b47b"),
 * 					TenantId:      pulumi.String("72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("pajindTest"),
 * 			SiteName:          pulumi.String("appliance1e39site"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.HyperVSite;
 * import com.pulumi.azurenative.offazure.HyperVSiteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hyperVSite = new HyperVSite("hyperVSite", HyperVSiteArgs.builder()
 *             .location("eastus")
 *             .properties(Map.of("servicePrincipalIdentityDetails", Map.ofEntries(
 *                 Map.entry("aadAuthority", "https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 *                 Map.entry("applicationId", "e9f013df-2a2a-4871-b766-e79867f30348"),
 *                 Map.entry("audience", "https://72f988bf-86f1-41af-91ab-2d7cd011db47/MaheshSite17ac9agentauthaadapp"),
 *                 Map.entry("objectId", "2cd492bc-7ef3-4ee0-b301-59a88108b47b"),
 *                 Map.entry("tenantId", "72f988bf-86f1-41af-91ab-2d7cd011db47")
 *             )))
 *             .resourceGroupName("pajindTest")
 *             .siteName("appliance1e39site")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazure:HyperVSite appliance1e39site /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/HyperVSites/{siteName}
 * ```
 */
public class HyperVSite internal constructor(
    override val javaResource: com.pulumi.azurenative.offazure.HyperVSite,
) : KotlinCustomResource(javaResource, HyperVSiteMapper) {
    /**
     * eTag for concurrency control.
     */
    public val eTag: Output<String>?
        get() = javaResource.eTag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure location in which Sites is created.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Name of the Hyper-V site.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Nested properties of Hyper-V site.
     */
    public val properties: Output<SitePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                sitePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Type of resource. Type = Microsoft.OffAzure/HyperVSites.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object HyperVSiteMapper : ResourceMapper<HyperVSite> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.offazure.HyperVSite::class == javaResource::class

    override fun map(javaResource: Resource): HyperVSite = HyperVSite(
        javaResource as
            com.pulumi.azurenative.offazure.HyperVSite,
    )
}

/**
 * @see [HyperVSite].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HyperVSite].
 */
public suspend fun hyperVSite(name: String, block: suspend HyperVSiteResourceBuilder.() -> Unit):
    HyperVSite {
    val builder = HyperVSiteResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HyperVSite].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hyperVSite(name: String): HyperVSite {
    val builder = HyperVSiteResourceBuilder()
    builder.name(name)
    return builder.build()
}
