@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin

import com.pulumi.azurenative.offazure.ImportSitesControllerArgs.builder
import com.pulumi.azurenative.offazure.kotlin.enums.ProvisioningState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A ImportSite
 * Azure REST API version: 2023-06-06.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### ImportSitesController_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var importSitesController = new AzureNative.OffAzure.ImportSitesController("importSitesController", new()
 *     {
 *         DiscoverySolutionId = "lfaswhiwdttdpkrvnrpriauexdjs",
 *         Location = "woctgvdufvkzvjcirjpf",
 *         ProvisioningState = "Created",
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "O-K1FS",
 *         Tags =
 *         {
 *             { "key2067", "taqzca" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewImportSitesController(ctx, "importSitesController", &offazure.ImportSitesControllerArgs{
 * 			DiscoverySolutionId: pulumi.String("lfaswhiwdttdpkrvnrpriauexdjs"),
 * 			Location:            pulumi.String("woctgvdufvkzvjcirjpf"),
 * 			ProvisioningState:   pulumi.String("Created"),
 * 			ResourceGroupName:   pulumi.String("rgmigrate"),
 * 			SiteName:            pulumi.String("O-K1FS"),
 * 			Tags: pulumi.StringMap{
 * 				"key2067": pulumi.String("taqzca"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.ImportSitesController;
 * import com.pulumi.azurenative.offazure.ImportSitesControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var importSitesController = new ImportSitesController("importSitesController", ImportSitesControllerArgs.builder()
 *             .discoverySolutionId("lfaswhiwdttdpkrvnrpriauexdjs")
 *             .location("woctgvdufvkzvjcirjpf")
 *             .provisioningState("Created")
 *             .resourceGroupName("rgmigrate")
 *             .siteName("O-K1FS")
 *             .tags(Map.of("key2067", "taqzca"))
 *             .build());
 *     }
 * }
 * ```
 * ### ImportSitesController_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var importSitesController = new AzureNative.OffAzure.ImportSitesController("importSitesController", new()
 *     {
 *         Location = "woctgvdufvkzvjcirjpf",
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "IHPDPK-1-",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewImportSitesController(ctx, "importSitesController", &offazure.ImportSitesControllerArgs{
 * 			Location:          pulumi.String("woctgvdufvkzvjcirjpf"),
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			SiteName:          pulumi.String("IHPDPK-1-"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.ImportSitesController;
 * import com.pulumi.azurenative.offazure.ImportSitesControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var importSitesController = new ImportSitesController("importSitesController", ImportSitesControllerArgs.builder()
 *             .location("woctgvdufvkzvjcirjpf")
 *             .resourceGroupName("rgmigrate")
 *             .siteName("IHPDPK-1-")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazure:ImportSitesController tqrloxeytbqkupcidyfjzkib /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/importSites/{siteName}
 * ```
 * @property discoverySolutionId Gets or sets the ARM ID of migration hub solution for SDS.
 * @property location The geo-location where the resource lives
 * @property provisioningState The status of the last operation.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property siteName Site name
 * @property tags Resource tags.
 */
public data class ImportSitesControllerArgs(
    public val discoverySolutionId: Output<String>? = null,
    public val location: Output<String>? = null,
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val siteName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.offazure.ImportSitesControllerArgs> {
    override fun toJava(): com.pulumi.azurenative.offazure.ImportSitesControllerArgs =
        com.pulumi.azurenative.offazure.ImportSitesControllerArgs.builder()
            .discoverySolutionId(discoverySolutionId?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .siteName(siteName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ImportSitesControllerArgs].
 */
@PulumiTagMarker
public class ImportSitesControllerArgsBuilder internal constructor() {
    private var discoverySolutionId: Output<String>? = null

    private var location: Output<String>? = null

    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    private var resourceGroupName: Output<String>? = null

    private var siteName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Gets or sets the ARM ID of migration hub solution for SDS.
     */
    @JvmName("mepwukrrtrdetcrf")
    public suspend fun discoverySolutionId(`value`: Output<String>) {
        this.discoverySolutionId = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("dknqowvsjflpsxmo")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("inkyxrgdduvtjohl")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sbbjrnnjbmoalgws")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Site name
     */
    @JvmName("uiojuhkmqvhcajev")
    public suspend fun siteName(`value`: Output<String>) {
        this.siteName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("drlanesfafjnaqvy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Gets or sets the ARM ID of migration hub solution for SDS.
     */
    @JvmName("enfaqsjlfiyrgnyg")
    public suspend fun discoverySolutionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discoverySolutionId = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("qdnpmhyxllbwnkxp")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("mebnfkemaoosihjt")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("yinrhsnrttabflfm")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("taxusurhpxtpfhsh")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("flwcjgukuodedfbi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Site name
     */
    @JvmName("ipxvcguinbqjalfu")
    public suspend fun siteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("aaiotpguojbumhwr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("brydjmtcufqunecb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ImportSitesControllerArgs = ImportSitesControllerArgs(
        discoverySolutionId = discoverySolutionId,
        location = location,
        provisioningState = provisioningState,
        resourceGroupName = resourceGroupName,
        siteName = siteName,
        tags = tags,
    )
}
