@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin

import com.pulumi.azurenative.offazure.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.offazure.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [MasterSitesController].
 */
@PulumiTagMarker
public class MasterSitesControllerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MasterSitesControllerArgs = MasterSitesControllerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MasterSitesControllerArgsBuilder.() -> Unit) {
        val builder = MasterSitesControllerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MasterSitesController {
        val builtJavaResource =
            com.pulumi.azurenative.offazure.MasterSitesController(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MasterSitesController(builtJavaResource)
    }
}

/**
 * A MasterSite
 * Azure REST API version: 2023-06-06.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### MasterSitesController_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var masterSitesController = new AzureNative.OffAzure.MasterSitesController("masterSitesController", new()
 *     {
 *         AllowMultipleSites = true,
 *         CustomerStorageAccountArmId = "cdxrihtiskkn",
 *         Location = "plyak",
 *         PublicNetworkAccess = "NotSpecified",
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "74c1J1m56557t52H-75",
 *         Sites = new[]
 *         {
 *             "zxupfq",
 *         },
 *         Tags =
 *         {
 *             { "key7125", "jbhnzfuxjovyamasouyfhhzhevagvw" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewMasterSitesController(ctx, "masterSitesController", &offazure.MasterSitesControllerArgs{
 * 			AllowMultipleSites:          pulumi.Bool(true),
 * 			CustomerStorageAccountArmId: pulumi.String("cdxrihtiskkn"),
 * 			Location:                    pulumi.String("plyak"),
 * 			PublicNetworkAccess:         pulumi.String("NotSpecified"),
 * 			ResourceGroupName:           pulumi.String("rgmigrate"),
 * 			SiteName:                    pulumi.String("74c1J1m56557t52H-75"),
 * 			Sites: pulumi.StringArray{
 * 				pulumi.String("zxupfq"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key7125": pulumi.String("jbhnzfuxjovyamasouyfhhzhevagvw"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.MasterSitesController;
 * import com.pulumi.azurenative.offazure.MasterSitesControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var masterSitesController = new MasterSitesController("masterSitesController", MasterSitesControllerArgs.builder()
 *             .allowMultipleSites(true)
 *             .customerStorageAccountArmId("cdxrihtiskkn")
 *             .location("plyak")
 *             .publicNetworkAccess("NotSpecified")
 *             .resourceGroupName("rgmigrate")
 *             .siteName("74c1J1m56557t52H-75")
 *             .sites("zxupfq")
 *             .tags(Map.of("key7125", "jbhnzfuxjovyamasouyfhhzhevagvw"))
 *             .build());
 *     }
 * }
 * ```
 * ### MasterSitesController_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var masterSitesController = new AzureNative.OffAzure.MasterSitesController("masterSitesController", new()
 *     {
 *         Location = "plyak",
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "-3A8SuY-jRr63J",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewMasterSitesController(ctx, "masterSitesController", &offazure.MasterSitesControllerArgs{
 * 			Location:          pulumi.String("plyak"),
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			SiteName:          pulumi.String("-3A8SuY-jRr63J"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.MasterSitesController;
 * import com.pulumi.azurenative.offazure.MasterSitesControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var masterSitesController = new MasterSitesController("masterSitesController", MasterSitesControllerArgs.builder()
 *             .location("plyak")
 *             .resourceGroupName("rgmigrate")
 *             .siteName("-3A8SuY-jRr63J")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazure:MasterSitesController asmdtexbhrvpepiavab /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/masterSites/{siteName}
 * ```
 */
public class MasterSitesController internal constructor(
    override val javaResource: com.pulumi.azurenative.offazure.MasterSitesController,
) : KotlinCustomResource(javaResource, MasterSitesControllerMapper) {
    /**
     * Gets or sets a value indicating whether multiple sites per site type are
     * allowed.
     */
    public val allowMultipleSites: Output<Boolean>?
        get() = javaResource.allowMultipleSites().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets a value for customer storage account ARM id.
     */
    public val customerStorageAccountArmId: Output<String>?
        get() = javaResource.customerStorageAccountArmId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets the nested sites under Master Site.
     */
    public val nestedSites: Output<List<String>>
        get() = javaResource.nestedSites().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Gets the private endpoint connections.
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * provisioning state enum
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the state of public network access.
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the sites that are a part of Master Site.
     *             The key
     * should contain the Site ARM name.
     */
    public val sites: Output<List<String>>?
        get() = javaResource.sites().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MasterSitesControllerMapper : ResourceMapper<MasterSitesController> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.offazure.MasterSitesController::class == javaResource::class

    override fun map(javaResource: Resource): MasterSitesController =
        MasterSitesController(javaResource as com.pulumi.azurenative.offazure.MasterSitesController)
}

/**
 * @see [MasterSitesController].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MasterSitesController].
 */
public suspend fun masterSitesController(
    name: String,
    block: suspend MasterSitesControllerResourceBuilder.() -> Unit,
): MasterSitesController {
    val builder = MasterSitesControllerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MasterSitesController].
 * @param name The _unique_ name of the resulting resource.
 */
public fun masterSitesController(name: String): MasterSitesController {
    val builder = MasterSitesControllerResourceBuilder()
    builder.name(name)
    return builder.build()
}
