@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin

import com.pulumi.azurenative.offazure.ServerSitesControllerArgs.builder
import com.pulumi.azurenative.offazure.kotlin.inputs.SiteAgentPropertiesArgs
import com.pulumi.azurenative.offazure.kotlin.inputs.SiteAgentPropertiesArgsBuilder
import com.pulumi.azurenative.offazure.kotlin.inputs.SiteSpnPropertiesArgs
import com.pulumi.azurenative.offazure.kotlin.inputs.SiteSpnPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A ServerSiteResource
 * Azure REST API version: 2023-06-06.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### ServerSitesController_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverSitesController = new AzureNative.OffAzure.ServerSitesController("serverSitesController", new()
 *     {
 *         AgentDetails = new AzureNative.OffAzure.Inputs.SiteAgentPropertiesArgs
 *         {
 *             KeyVaultId = "awxurtbjmofxuciewsqfgpkccpzw",
 *             KeyVaultUri = "qizphgqwage",
 *         },
 *         ApplianceName = "zkzibwptff",
 *         DiscoverySolutionId = "lvskpghpphpfumbzxroakznqplomiy",
 *         Location = "iipybgplhzhpcfv",
 *         ResourceGroupName = "rgmigrate",
 *         ServicePrincipalIdentityDetails = new AzureNative.OffAzure.Inputs.SiteSpnPropertiesArgs
 *         {
 *             AadAuthority = "yanzipdww",
 *             ApplicationId = "tspgrujepxyxuprkqvfuqbbjrweeqa",
 *             Audience = "oepwfaozztzvegmzvswafvotj",
 *             ObjectId = "tqrjngpgxnnto",
 *             RawCertData = "dotvgkslkmsgvtekgojnhcdrryk",
 *             TenantId = "vesmyhu",
 *         },
 *         SiteName = "XD1X78SG23",
 *         Tags =
 *         {
 *             { "key4244", "yryvgpkoefkjkhlcahntgfz" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewServerSitesController(ctx, "serverSitesController", &offazure.ServerSitesControllerArgs{
 * 			AgentDetails: &offazure.SiteAgentPropertiesArgs{
 * 				KeyVaultId:  pulumi.String("awxurtbjmofxuciewsqfgpkccpzw"),
 * 				KeyVaultUri: pulumi.String("qizphgqwage"),
 * 			},
 * 			ApplianceName:       pulumi.String("zkzibwptff"),
 * 			DiscoverySolutionId: pulumi.String("lvskpghpphpfumbzxroakznqplomiy"),
 * 			Location:            pulumi.String("iipybgplhzhpcfv"),
 * 			ResourceGroupName:   pulumi.String("rgmigrate"),
 * 			ServicePrincipalIdentityDetails: &offazure.SiteSpnPropertiesArgs{
 * 				AadAuthority:  pulumi.String("yanzipdww"),
 * 				ApplicationId: pulumi.String("tspgrujepxyxuprkqvfuqbbjrweeqa"),
 * 				Audience:      pulumi.String("oepwfaozztzvegmzvswafvotj"),
 * 				ObjectId:      pulumi.String("tqrjngpgxnnto"),
 * 				RawCertData:   pulumi.String("dotvgkslkmsgvtekgojnhcdrryk"),
 * 				TenantId:      pulumi.String("vesmyhu"),
 * 			},
 * 			SiteName: pulumi.String("XD1X78SG23"),
 * 			Tags: pulumi.StringMap{
 * 				"key4244": pulumi.String("yryvgpkoefkjkhlcahntgfz"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.ServerSitesController;
 * import com.pulumi.azurenative.offazure.ServerSitesControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverSitesController = new ServerSitesController("serverSitesController", ServerSitesControllerArgs.builder()
 *             .agentDetails(Map.ofEntries(
 *                 Map.entry("keyVaultId", "awxurtbjmofxuciewsqfgpkccpzw"),
 *                 Map.entry("keyVaultUri", "qizphgqwage")
 *             ))
 *             .applianceName("zkzibwptff")
 *             .discoverySolutionId("lvskpghpphpfumbzxroakznqplomiy")
 *             .location("iipybgplhzhpcfv")
 *             .resourceGroupName("rgmigrate")
 *             .servicePrincipalIdentityDetails(Map.ofEntries(
 *                 Map.entry("aadAuthority", "yanzipdww"),
 *                 Map.entry("applicationId", "tspgrujepxyxuprkqvfuqbbjrweeqa"),
 *                 Map.entry("audience", "oepwfaozztzvegmzvswafvotj"),
 *                 Map.entry("objectId", "tqrjngpgxnnto"),
 *                 Map.entry("rawCertData", "dotvgkslkmsgvtekgojnhcdrryk"),
 *                 Map.entry("tenantId", "vesmyhu")
 *             ))
 *             .siteName("XD1X78SG23")
 *             .tags(Map.of("key4244", "yryvgpkoefkjkhlcahntgfz"))
 *             .build());
 *     }
 * }
 * ```
 * ### ServerSitesController_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverSitesController = new AzureNative.OffAzure.ServerSitesController("serverSitesController", new()
 *     {
 *         Location = "iipybgplhzhpcfv",
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "74-35-",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewServerSitesController(ctx, "serverSitesController", &offazure.ServerSitesControllerArgs{
 * 			Location:          pulumi.String("iipybgplhzhpcfv"),
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			SiteName:          pulumi.String("74-35-"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.ServerSitesController;
 * import com.pulumi.azurenative.offazure.ServerSitesControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverSitesController = new ServerSitesController("serverSitesController", ServerSitesControllerArgs.builder()
 *             .location("iipybgplhzhpcfv")
 *             .resourceGroupName("rgmigrate")
 *             .siteName("74-35-")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazure:ServerSitesController eslhfxcnkskfrjdblkkko /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/serverSites/{siteName}
 * ```
 * @property agentDetails Gets or sets the on-premises agent details.
 * @property applianceName Gets or sets the Appliance Name.
 * @property discoverySolutionId Gets or sets the ARM ID of migration hub solution for SDS.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property servicePrincipalIdentityDetails Gets or sets the service principal identity details used by agent for
 * communication
 *             to the service.
 * @property siteName Site name
 * @property tags Resource tags.
 */
public data class ServerSitesControllerArgs(
    public val agentDetails: Output<SiteAgentPropertiesArgs>? = null,
    public val applianceName: Output<String>? = null,
    public val discoverySolutionId: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val servicePrincipalIdentityDetails: Output<SiteSpnPropertiesArgs>? = null,
    public val siteName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.offazure.ServerSitesControllerArgs> {
    override fun toJava(): com.pulumi.azurenative.offazure.ServerSitesControllerArgs =
        com.pulumi.azurenative.offazure.ServerSitesControllerArgs.builder()
            .agentDetails(agentDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .applianceName(applianceName?.applyValue({ args0 -> args0 }))
            .discoverySolutionId(discoverySolutionId?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .servicePrincipalIdentityDetails(
                servicePrincipalIdentityDetails?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .siteName(siteName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ServerSitesControllerArgs].
 */
@PulumiTagMarker
public class ServerSitesControllerArgsBuilder internal constructor() {
    private var agentDetails: Output<SiteAgentPropertiesArgs>? = null

    private var applianceName: Output<String>? = null

    private var discoverySolutionId: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var servicePrincipalIdentityDetails: Output<SiteSpnPropertiesArgs>? = null

    private var siteName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Gets or sets the on-premises agent details.
     */
    @JvmName("axyaixipreletxqc")
    public suspend fun agentDetails(`value`: Output<SiteAgentPropertiesArgs>) {
        this.agentDetails = value
    }

    /**
     * @param value Gets or sets the Appliance Name.
     */
    @JvmName("kngpnijnungqekry")
    public suspend fun applianceName(`value`: Output<String>) {
        this.applianceName = value
    }

    /**
     * @param value Gets or sets the ARM ID of migration hub solution for SDS.
     */
    @JvmName("lofatvhegfkodjvo")
    public suspend fun discoverySolutionId(`value`: Output<String>) {
        this.discoverySolutionId = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("lwxiqiorruyndybe")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xadybcmjdscbnajb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets the service principal identity details used by agent for
     * communication
     *             to the service.
     */
    @JvmName("vvbhbrbakuongrwn")
    public suspend fun servicePrincipalIdentityDetails(`value`: Output<SiteSpnPropertiesArgs>) {
        this.servicePrincipalIdentityDetails = value
    }

    /**
     * @param value Site name
     */
    @JvmName("bjbvsawuvwmrmyve")
    public suspend fun siteName(`value`: Output<String>) {
        this.siteName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("agsuxfmegmtgpncp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Gets or sets the on-premises agent details.
     */
    @JvmName("lyfiqnvmfgoutgdk")
    public suspend fun agentDetails(`value`: SiteAgentPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentDetails = mapped
    }

    /**
     * @param argument Gets or sets the on-premises agent details.
     */
    @JvmName("ghsvyixkswbjciob")
    public suspend fun agentDetails(argument: suspend SiteAgentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SiteAgentPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.agentDetails = mapped
    }

    /**
     * @param value Gets or sets the Appliance Name.
     */
    @JvmName("fndedhayrfqrvgua")
    public suspend fun applianceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applianceName = mapped
    }

    /**
     * @param value Gets or sets the ARM ID of migration hub solution for SDS.
     */
    @JvmName("bldyonohwlgjtomw")
    public suspend fun discoverySolutionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discoverySolutionId = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("btngaiodtuvytsol")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pnaqixmlousnywdk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the service principal identity details used by agent for
     * communication
     *             to the service.
     */
    @JvmName("qwccsqnwhgporcob")
    public suspend fun servicePrincipalIdentityDetails(`value`: SiteSpnPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalIdentityDetails = mapped
    }

    /**
     * @param argument Gets or sets the service principal identity details used by agent for
     * communication
     *             to the service.
     */
    @JvmName("phjhlvgewbctufho")
    public suspend
    fun servicePrincipalIdentityDetails(argument: suspend SiteSpnPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SiteSpnPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.servicePrincipalIdentityDetails = mapped
    }

    /**
     * @param value Site name
     */
    @JvmName("uosknmmyvxdnpohl")
    public suspend fun siteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ykiejewmmshiolwn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("duqmsdtiktcmhcho")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ServerSitesControllerArgs = ServerSitesControllerArgs(
        agentDetails = agentDetails,
        applianceName = applianceName,
        discoverySolutionId = discoverySolutionId,
        location = location,
        resourceGroupName = resourceGroupName,
        servicePrincipalIdentityDetails = servicePrincipalIdentityDetails,
        siteName = siteName,
        tags = tags,
    )
}
