@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin

import com.pulumi.azurenative.offazure.SiteArgs.builder
import com.pulumi.azurenative.offazure.kotlin.inputs.SitePropertiesArgs
import com.pulumi.azurenative.offazure.kotlin.inputs.SitePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Site REST Resource.
 * Azure REST API version: 2020-07-07. Prior API version in Azure Native 1.x: 2020-01-01.
 * ## Example Usage
 * ### Create VMware site
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var site = new AzureNative.OffAzure.Site("site", new()
 *     {
 *         Location = "eastus",
 *         Properties = new AzureNative.OffAzure.Inputs.SitePropertiesArgs
 *         {
 *             ServicePrincipalIdentityDetails = new AzureNative.OffAzure.Inputs.SiteSpnPropertiesArgs
 *             {
 *                 AadAuthority = "https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47",
 *                 ApplicationId = "e9f013df-2a2a-4871-b766-e79867f30348",
 *                 Audience = "https://72f988bf-86f1-41af-91ab-2d7cd011db47/MaheshSite17ac9agentauthaadapp",
 *                 ObjectId = "2cd492bc-7ef3-4ee0-b301-59a88108b47b",
 *                 TenantId = "72f988bf-86f1-41af-91ab-2d7cd011db47",
 *             },
 *         },
 *         ResourceGroupName = "pajindTest",
 *         SiteName = "appliance1e39site",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewSite(ctx, "site", &offazure.SiteArgs{
 * 			Location: pulumi.String("eastus"),
 * 			Properties: offazure.SitePropertiesResponse{
 * 				ServicePrincipalIdentityDetails: &offazure.SiteSpnPropertiesArgs{
 * 					AadAuthority:  pulumi.String("https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 					ApplicationId: pulumi.String("e9f013df-2a2a-4871-b766-e79867f30348"),
 * 					Audience:      pulumi.String("https://72f988bf-86f1-41af-91ab-2d7cd011db47/MaheshSite17ac9agentauthaadapp"),
 * 					ObjectId:      pulumi.String("2cd492bc-7ef3-4ee0-b301-59a88108b47b"),
 * 					TenantId:      pulumi.String("72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("pajindTest"),
 * 			SiteName:          pulumi.String("appliance1e39site"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.Site;
 * import com.pulumi.azurenative.offazure.SiteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var site = new Site("site", SiteArgs.builder()
 *             .location("eastus")
 *             .properties(Map.of("servicePrincipalIdentityDetails", Map.ofEntries(
 *                 Map.entry("aadAuthority", "https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 *                 Map.entry("applicationId", "e9f013df-2a2a-4871-b766-e79867f30348"),
 *                 Map.entry("audience", "https://72f988bf-86f1-41af-91ab-2d7cd011db47/MaheshSite17ac9agentauthaadapp"),
 *                 Map.entry("objectId", "2cd492bc-7ef3-4ee0-b301-59a88108b47b"),
 *                 Map.entry("tenantId", "72f988bf-86f1-41af-91ab-2d7cd011db47")
 *             )))
 *             .resourceGroupName("pajindTest")
 *             .siteName("appliance1e39site")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazure:Site appliance1e39site /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/VMwareSites/{siteName}
 * ```
 * @property eTag eTag for concurrency control.
 * @property location Azure location in which Sites is created.
 * @property name Name of the VMware site.
 * @property properties Nested properties of VMWare site.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property siteName Site name.
 * @property tags
 */
public data class SiteArgs(
    public val eTag: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val properties: Output<SitePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val siteName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.offazure.SiteArgs> {
    override fun toJava(): com.pulumi.azurenative.offazure.SiteArgs =
        com.pulumi.azurenative.offazure.SiteArgs.builder()
            .eTag(eTag?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .siteName(siteName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SiteArgs].
 */
@PulumiTagMarker
public class SiteArgsBuilder internal constructor() {
    private var eTag: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var properties: Output<SitePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var siteName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value eTag for concurrency control.
     */
    @JvmName("chhjcvvrqsiupvnp")
    public suspend fun eTag(`value`: Output<String>) {
        this.eTag = value
    }

    /**
     * @param value Azure location in which Sites is created.
     */
    @JvmName("fdtbwxkgjpvdlpyo")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the VMware site.
     */
    @JvmName("bdmicblyisgrbuva")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Nested properties of VMWare site.
     */
    @JvmName("tcpvhecwpauqdpyu")
    public suspend fun properties(`value`: Output<SitePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wstplxmpfwpicdhc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Site name.
     */
    @JvmName("kgubawxcidhhtrfc")
    public suspend fun siteName(`value`: Output<String>) {
        this.siteName = value
    }

    /**
     * @param value
     */
    @JvmName("nkbjurixlphmtbln")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value eTag for concurrency control.
     */
    @JvmName("rccwjqqohvxkogxh")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eTag = mapped
    }

    /**
     * @param value Azure location in which Sites is created.
     */
    @JvmName("slwyvuiknbojsklu")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the VMware site.
     */
    @JvmName("jmbnecgtuxghmldu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Nested properties of VMWare site.
     */
    @JvmName("ouxurkgvgeyyhhcp")
    public suspend fun properties(`value`: SitePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Nested properties of VMWare site.
     */
    @JvmName("gcvkedgrykjtvqie")
    public suspend fun properties(argument: suspend SitePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SitePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("blyefxtktbkvuuyp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Site name.
     */
    @JvmName("plpbcbqkopdstbak")
    public suspend fun siteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteName = mapped
    }

    /**
     * @param value
     */
    @JvmName("jregtdoafjngnuxf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("kadbegqwlyabtvmb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SiteArgs = SiteArgs(
        eTag = eTag,
        location = location,
        name = name,
        properties = properties,
        resourceGroupName = resourceGroupName,
        siteName = siteName,
        tags = tags,
    )
}
