@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin

import com.pulumi.azurenative.offazure.SqlDiscoverySiteDataSourceControllerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A SQL discovery site data source resource.
 * Azure REST API version: 2023-06-06.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### SqlDiscoverySiteDataSourceController_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlDiscoverySiteDataSourceController = new AzureNative.OffAzure.SqlDiscoverySiteDataSourceController("sqlDiscoverySiteDataSourceController", new()
 *     {
 *         DiscoverySiteDataSourceName = "q3--4O9O5vc-2",
 *         DiscoverySiteId = "xvtylcidvhdspuw",
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "qU5b-1JBE45EC6Z-IF",
 *         SqlSiteName = "I5-O3912-L3y2Q57",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewSqlDiscoverySiteDataSourceController(ctx, "sqlDiscoverySiteDataSourceController", &offazure.SqlDiscoverySiteDataSourceControllerArgs{
 * 			DiscoverySiteDataSourceName: pulumi.String("q3--4O9O5vc-2"),
 * 			DiscoverySiteId:             pulumi.String("xvtylcidvhdspuw"),
 * 			ResourceGroupName:           pulumi.String("rgmigrate"),
 * 			SiteName:                    pulumi.String("qU5b-1JBE45EC6Z-IF"),
 * 			SqlSiteName:                 pulumi.String("I5-O3912-L3y2Q57"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.SqlDiscoverySiteDataSourceController;
 * import com.pulumi.azurenative.offazure.SqlDiscoverySiteDataSourceControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlDiscoverySiteDataSourceController = new SqlDiscoverySiteDataSourceController("sqlDiscoverySiteDataSourceController", SqlDiscoverySiteDataSourceControllerArgs.builder()
 *             .discoverySiteDataSourceName("q3--4O9O5vc-2")
 *             .discoverySiteId("xvtylcidvhdspuw")
 *             .resourceGroupName("rgmigrate")
 *             .siteName("qU5b-1JBE45EC6Z-IF")
 *             .sqlSiteName("I5-O3912-L3y2Q57")
 *             .build());
 *     }
 * }
 * ```
 * ### SqlDiscoverySiteDataSourceController_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlDiscoverySiteDataSourceController = new AzureNative.OffAzure.SqlDiscoverySiteDataSourceController("sqlDiscoverySiteDataSourceController", new()
 *     {
 *         DiscoverySiteDataSourceName = "Sw-cch",
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "-2n-j-5O",
 *         SqlSiteName = "32F0K64",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewSqlDiscoverySiteDataSourceController(ctx, "sqlDiscoverySiteDataSourceController", &offazure.SqlDiscoverySiteDataSourceControllerArgs{
 * 			DiscoverySiteDataSourceName: pulumi.String("Sw-cch"),
 * 			ResourceGroupName:           pulumi.String("rgmigrate"),
 * 			SiteName:                    pulumi.String("-2n-j-5O"),
 * 			SqlSiteName:                 pulumi.String("32F0K64"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.SqlDiscoverySiteDataSourceController;
 * import com.pulumi.azurenative.offazure.SqlDiscoverySiteDataSourceControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlDiscoverySiteDataSourceController = new SqlDiscoverySiteDataSourceController("sqlDiscoverySiteDataSourceController", SqlDiscoverySiteDataSourceControllerArgs.builder()
 *             .discoverySiteDataSourceName("Sw-cch")
 *             .resourceGroupName("rgmigrate")
 *             .siteName("-2n-j-5O")
 *             .sqlSiteName("32F0K64")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazure:SqlDiscoverySiteDataSourceController aasatr /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/masterSites/{siteName}/sqlSites/{sqlSiteName}/discoverySiteDataSources/{discoverySiteDataSourceName}
 * ```
 * @property discoverySiteDataSourceName SQL Discovery site data source name.
 * @property discoverySiteId Gets or sets the discovery site Id.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property siteName Site name
 * @property sqlSiteName SQL site name.
 */
public data class SqlDiscoverySiteDataSourceControllerArgs(
    public val discoverySiteDataSourceName: Output<String>? = null,
    public val discoverySiteId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val siteName: Output<String>? = null,
    public val sqlSiteName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.offazure.SqlDiscoverySiteDataSourceControllerArgs> {
    override fun toJava(): com.pulumi.azurenative.offazure.SqlDiscoverySiteDataSourceControllerArgs =
        com.pulumi.azurenative.offazure.SqlDiscoverySiteDataSourceControllerArgs.builder()
            .discoverySiteDataSourceName(discoverySiteDataSourceName?.applyValue({ args0 -> args0 }))
            .discoverySiteId(discoverySiteId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .siteName(siteName?.applyValue({ args0 -> args0 }))
            .sqlSiteName(sqlSiteName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlDiscoverySiteDataSourceControllerArgs].
 */
@PulumiTagMarker
public class SqlDiscoverySiteDataSourceControllerArgsBuilder internal constructor() {
    private var discoverySiteDataSourceName: Output<String>? = null

    private var discoverySiteId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var siteName: Output<String>? = null

    private var sqlSiteName: Output<String>? = null

    /**
     * @param value SQL Discovery site data source name.
     */
    @JvmName("htyaunlkkxbejpfu")
    public suspend fun discoverySiteDataSourceName(`value`: Output<String>) {
        this.discoverySiteDataSourceName = value
    }

    /**
     * @param value Gets or sets the discovery site Id.
     */
    @JvmName("wkgkochnpjlfmhkj")
    public suspend fun discoverySiteId(`value`: Output<String>) {
        this.discoverySiteId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fmomnesyhxqvlnkb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Site name
     */
    @JvmName("vmcfoujkygmnjcjf")
    public suspend fun siteName(`value`: Output<String>) {
        this.siteName = value
    }

    /**
     * @param value SQL site name.
     */
    @JvmName("mdqduebrimyxgrac")
    public suspend fun sqlSiteName(`value`: Output<String>) {
        this.sqlSiteName = value
    }

    /**
     * @param value SQL Discovery site data source name.
     */
    @JvmName("okfgfocqjgtvporr")
    public suspend fun discoverySiteDataSourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discoverySiteDataSourceName = mapped
    }

    /**
     * @param value Gets or sets the discovery site Id.
     */
    @JvmName("tmpcrpweiiaxqluf")
    public suspend fun discoverySiteId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discoverySiteId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lchgaxeddrkupykw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Site name
     */
    @JvmName("dtxnrttbctqwgrha")
    public suspend fun siteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteName = mapped
    }

    /**
     * @param value SQL site name.
     */
    @JvmName("nithiuphsgjxoeeu")
    public suspend fun sqlSiteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlSiteName = mapped
    }

    internal fun build(): SqlDiscoverySiteDataSourceControllerArgs =
        SqlDiscoverySiteDataSourceControllerArgs(
            discoverySiteDataSourceName = discoverySiteDataSourceName,
            discoverySiteId = discoverySiteId,
            resourceGroupName = resourceGroupName,
            siteName = siteName,
            sqlSiteName = sqlSiteName,
        )
}
