@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin

import com.pulumi.azurenative.offazure.WebAppSitesControllerArgs.builder
import com.pulumi.azurenative.offazure.kotlin.enums.WebAppSitePropertiesDiscoveryScenario
import com.pulumi.azurenative.offazure.kotlin.inputs.SiteAppliancePropertiesArgs
import com.pulumi.azurenative.offazure.kotlin.inputs.SiteAppliancePropertiesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * WebApp site web model.
 * Azure REST API version: 2023-06-06.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### WebAppSitesController_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webAppSitesController = new AzureNative.OffAzure.WebAppSitesController("webAppSitesController", new()
 *     {
 *         DiscoveryScenario = "Migrate",
 *         ResourceGroupName = "rgmigrate",
 *         SiteAppliancePropertiesCollection = new[]
 *         {
 *             new AzureNative.OffAzure.Inputs.SiteAppliancePropertiesArgs
 *             {
 *                 AgentDetails = new AzureNative.OffAzure.Inputs.SiteAgentPropertiesArgs
 *                 {
 *                     KeyVaultId = "awxurtbjmofxuciewsqfgpkccpzw",
 *                     KeyVaultUri = "qizphgqwage",
 *                 },
 *                 ApplianceName = "zpbkpigahvexsxevwafzgsu",
 *                 ServicePrincipalIdentityDetails = new AzureNative.OffAzure.Inputs.SiteSpnPropertiesArgs
 *                 {
 *                     AadAuthority = "yanzipdww",
 *                     ApplicationId = "tspgrujepxyxuprkqvfuqbbjrweeqa",
 *                     Audience = "oepwfaozztzvegmzvswafvotj",
 *                     ObjectId = "tqrjngpgxnnto",
 *                     RawCertData = "dotvgkslkmsgvtekgojnhcdrryk",
 *                     TenantId = "vesmyhu",
 *                 },
 *             },
 *         },
 *         SiteName = "36cmQ",
 *         WebAppSiteName = "GJRq",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewWebAppSitesController(ctx, "webAppSitesController", &offazure.WebAppSitesControllerArgs{
 * 			DiscoveryScenario: pulumi.String("Migrate"),
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			SiteAppliancePropertiesCollection: []offazure.SiteAppliancePropertiesArgs{
 * 				{
 * 					AgentDetails: {
 * 						KeyVaultId:  pulumi.String("awxurtbjmofxuciewsqfgpkccpzw"),
 * 						KeyVaultUri: pulumi.String("qizphgqwage"),
 * 					},
 * 					ApplianceName: pulumi.String("zpbkpigahvexsxevwafzgsu"),
 * 					ServicePrincipalIdentityDetails: {
 * 						AadAuthority:  pulumi.String("yanzipdww"),
 * 						ApplicationId: pulumi.String("tspgrujepxyxuprkqvfuqbbjrweeqa"),
 * 						Audience:      pulumi.String("oepwfaozztzvegmzvswafvotj"),
 * 						ObjectId:      pulumi.String("tqrjngpgxnnto"),
 * 						RawCertData:   pulumi.String("dotvgkslkmsgvtekgojnhcdrryk"),
 * 						TenantId:      pulumi.String("vesmyhu"),
 * 					},
 * 				},
 * 			},
 * 			SiteName:       pulumi.String("36cmQ"),
 * 			WebAppSiteName: pulumi.String("GJRq"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.WebAppSitesController;
 * import com.pulumi.azurenative.offazure.WebAppSitesControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webAppSitesController = new WebAppSitesController("webAppSitesController", WebAppSitesControllerArgs.builder()
 *             .discoveryScenario("Migrate")
 *             .resourceGroupName("rgmigrate")
 *             .siteAppliancePropertiesCollection(Map.ofEntries(
 *                 Map.entry("agentDetails", Map.ofEntries(
 *                     Map.entry("keyVaultId", "awxurtbjmofxuciewsqfgpkccpzw"),
 *                     Map.entry("keyVaultUri", "qizphgqwage")
 *                 )),
 *                 Map.entry("applianceName", "zpbkpigahvexsxevwafzgsu"),
 *                 Map.entry("servicePrincipalIdentityDetails", Map.ofEntries(
 *                     Map.entry("aadAuthority", "yanzipdww"),
 *                     Map.entry("applicationId", "tspgrujepxyxuprkqvfuqbbjrweeqa"),
 *                     Map.entry("audience", "oepwfaozztzvegmzvswafvotj"),
 *                     Map.entry("objectId", "tqrjngpgxnnto"),
 *                     Map.entry("rawCertData", "dotvgkslkmsgvtekgojnhcdrryk"),
 *                     Map.entry("tenantId", "vesmyhu")
 *                 ))
 *             ))
 *             .siteName("36cmQ")
 *             .webAppSiteName("GJRq")
 *             .build());
 *     }
 * }
 * ```
 * ### WebAppSitesController_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webAppSitesController = new AzureNative.OffAzure.WebAppSitesController("webAppSitesController", new()
 *     {
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "s13669b---4sI",
 *         WebAppSiteName = "3BXk-O8O6W3-GB7J",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewWebAppSitesController(ctx, "webAppSitesController", &offazure.WebAppSitesControllerArgs{
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			SiteName:          pulumi.String("s13669b---4sI"),
 * 			WebAppSiteName:    pulumi.String("3BXk-O8O6W3-GB7J"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.WebAppSitesController;
 * import com.pulumi.azurenative.offazure.WebAppSitesControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webAppSitesController = new WebAppSitesController("webAppSitesController", WebAppSitesControllerArgs.builder()
 *             .resourceGroupName("rgmigrate")
 *             .siteName("s13669b---4sI")
 *             .webAppSiteName("3BXk-O8O6W3-GB7J")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazure:WebAppSitesController tyyjy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/masterSites/{siteName}/webAppSites/{webAppSiteName}
 * ```
 * @property discoveryScenario Gets or sets the discovery scenario.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property siteAppliancePropertiesCollection Gets or sets the appliance details used by service to communicate
 * to the appliance.
 * @property siteName Site name
 * @property webAppSiteName Web app site name.
 */
public data class WebAppSitesControllerArgs(
    public val discoveryScenario: Output<Either<String, WebAppSitePropertiesDiscoveryScenario>>? =
        null,
    public val resourceGroupName: Output<String>? = null,
    public val siteAppliancePropertiesCollection: Output<List<SiteAppliancePropertiesArgs>>? = null,
    public val siteName: Output<String>? = null,
    public val webAppSiteName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.offazure.WebAppSitesControllerArgs> {
    override fun toJava(): com.pulumi.azurenative.offazure.WebAppSitesControllerArgs =
        com.pulumi.azurenative.offazure.WebAppSitesControllerArgs.builder()
            .discoveryScenario(
                discoveryScenario?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .siteAppliancePropertiesCollection(
                siteAppliancePropertiesCollection?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .siteName(siteName?.applyValue({ args0 -> args0 }))
            .webAppSiteName(webAppSiteName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppSitesControllerArgs].
 */
@PulumiTagMarker
public class WebAppSitesControllerArgsBuilder internal constructor() {
    private var discoveryScenario: Output<Either<String, WebAppSitePropertiesDiscoveryScenario>>? =
        null

    private var resourceGroupName: Output<String>? = null

    private var siteAppliancePropertiesCollection: Output<List<SiteAppliancePropertiesArgs>>? = null

    private var siteName: Output<String>? = null

    private var webAppSiteName: Output<String>? = null

    /**
     * @param value Gets or sets the discovery scenario.
     */
    @JvmName("jxgplpfmccyybvvv")
    public suspend
    fun discoveryScenario(`value`: Output<Either<String, WebAppSitePropertiesDiscoveryScenario>>) {
        this.discoveryScenario = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tssbalaqnpsydbia")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets the appliance details used by service to communicate
     * to the appliance.
     */
    @JvmName("mbousaxlkfkikwpv")
    public suspend
    fun siteAppliancePropertiesCollection(`value`: Output<List<SiteAppliancePropertiesArgs>>) {
        this.siteAppliancePropertiesCollection = value
    }

    @JvmName("dmmdukthtqxatikg")
    public suspend fun siteAppliancePropertiesCollection(
        vararg
        values: Output<SiteAppliancePropertiesArgs>,
    ) {
        this.siteAppliancePropertiesCollection = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the appliance details used by service to communicate
     * to the appliance.
     */
    @JvmName("otabylwdoolvwpds")
    public suspend
    fun siteAppliancePropertiesCollection(values: List<Output<SiteAppliancePropertiesArgs>>) {
        this.siteAppliancePropertiesCollection = Output.all(values)
    }

    /**
     * @param value Site name
     */
    @JvmName("xonofirgxjrmksue")
    public suspend fun siteName(`value`: Output<String>) {
        this.siteName = value
    }

    /**
     * @param value Web app site name.
     */
    @JvmName("kmwdslnmjdukwpoc")
    public suspend fun webAppSiteName(`value`: Output<String>) {
        this.webAppSiteName = value
    }

    /**
     * @param value Gets or sets the discovery scenario.
     */
    @JvmName("biibqsamukeyknvp")
    public suspend
    fun discoveryScenario(`value`: Either<String, WebAppSitePropertiesDiscoveryScenario>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discoveryScenario = mapped
    }

    /**
     * @param value Gets or sets the discovery scenario.
     */
    @JvmName("hqvjpggtpuwnbkvj")
    public fun discoveryScenario(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WebAppSitePropertiesDiscoveryScenario>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.discoveryScenario = mapped
    }

    /**
     * @param value Gets or sets the discovery scenario.
     */
    @JvmName("qetqunqqsnvcfnoo")
    public fun discoveryScenario(`value`: WebAppSitePropertiesDiscoveryScenario) {
        val toBeMapped = Either.ofRight<String, WebAppSitePropertiesDiscoveryScenario>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.discoveryScenario = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dubxbdeqpfeougra")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the appliance details used by service to communicate
     * to the appliance.
     */
    @JvmName("jonbjregsrufrxtr")
    public suspend
    fun siteAppliancePropertiesCollection(`value`: List<SiteAppliancePropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteAppliancePropertiesCollection = mapped
    }

    /**
     * @param argument Gets or sets the appliance details used by service to communicate
     * to the appliance.
     */
    @JvmName("saubmhrhbuarwhep")
    public suspend
    fun siteAppliancePropertiesCollection(argument: List<suspend SiteAppliancePropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SiteAppliancePropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.siteAppliancePropertiesCollection = mapped
    }

    /**
     * @param argument Gets or sets the appliance details used by service to communicate
     * to the appliance.
     */
    @JvmName("pqbwktdhqrtwhgkh")
    public suspend fun siteAppliancePropertiesCollection(
        vararg
        argument: suspend SiteAppliancePropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SiteAppliancePropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.siteAppliancePropertiesCollection = mapped
    }

    /**
     * @param argument Gets or sets the appliance details used by service to communicate
     * to the appliance.
     */
    @JvmName("rtrgfjsmbspiynfn")
    public suspend
    fun siteAppliancePropertiesCollection(argument: suspend SiteAppliancePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SiteAppliancePropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.siteAppliancePropertiesCollection = mapped
    }

    /**
     * @param values Gets or sets the appliance details used by service to communicate
     * to the appliance.
     */
    @JvmName("qtcpuqjnkwqefrrx")
    public suspend fun siteAppliancePropertiesCollection(vararg values: SiteAppliancePropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.siteAppliancePropertiesCollection = mapped
    }

    /**
     * @param value Site name
     */
    @JvmName("wkdsprhpsyflfmxq")
    public suspend fun siteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteName = mapped
    }

    /**
     * @param value Web app site name.
     */
    @JvmName("nvneladrmgwxdwia")
    public suspend fun webAppSiteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webAppSiteName = mapped
    }

    internal fun build(): WebAppSitesControllerArgs = WebAppSitesControllerArgs(
        discoveryScenario = discoveryScenario,
        resourceGroupName = resourceGroupName,
        siteAppliancePropertiesCollection = siteAppliancePropertiesCollection,
        siteName = siteName,
        webAppSiteName = webAppSiteName,
    )
}
