@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin.inputs

import com.pulumi.azurenative.offazure.inputs.GetSqlDiscoverySiteDataSourceControllerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property discoverySiteDataSourceName SQL Discovery site data source name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property siteName Site name
 * @property sqlSiteName SQL site name.
 */
public data class GetSqlDiscoverySiteDataSourceControllerPlainArgs(
    public val discoverySiteDataSourceName: String,
    public val resourceGroupName: String,
    public val siteName: String,
    public val sqlSiteName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.offazure.inputs.GetSqlDiscoverySiteDataSourceControllerPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.offazure.inputs.GetSqlDiscoverySiteDataSourceControllerPlainArgs =
        com.pulumi.azurenative.offazure.inputs.GetSqlDiscoverySiteDataSourceControllerPlainArgs.builder()
            .discoverySiteDataSourceName(discoverySiteDataSourceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .siteName(siteName.let({ args0 -> args0 }))
            .sqlSiteName(sqlSiteName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSqlDiscoverySiteDataSourceControllerPlainArgs].
 */
@PulumiTagMarker
public class GetSqlDiscoverySiteDataSourceControllerPlainArgsBuilder internal constructor() {
    private var discoverySiteDataSourceName: String? = null

    private var resourceGroupName: String? = null

    private var siteName: String? = null

    private var sqlSiteName: String? = null

    /**
     * @param value SQL Discovery site data source name.
     */
    @JvmName("hjqmwxqyahohpxnk")
    public suspend fun discoverySiteDataSourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.discoverySiteDataSourceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vmldbqumkgcpljen")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Site name
     */
    @JvmName("ceynxswhhpprxpnv")
    public suspend fun siteName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.siteName = mapped
    }

    /**
     * @param value SQL site name.
     */
    @JvmName("xmlykbuabdulettr")
    public suspend fun sqlSiteName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sqlSiteName = mapped
    }

    internal fun build(): GetSqlDiscoverySiteDataSourceControllerPlainArgs =
        GetSqlDiscoverySiteDataSourceControllerPlainArgs(
            discoverySiteDataSourceName = discoverySiteDataSourceName ?: throw
                PulumiNullFieldException("discoverySiteDataSourceName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            siteName = siteName ?: throw PulumiNullFieldException("siteName"),
            sqlSiteName = sqlSiteName ?: throw PulumiNullFieldException("sqlSiteName"),
        )
}
