@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * WebApp site web model.
 * @property discoveryScenario Gets or sets the discovery scenario.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property provisioningState provisioning state enum
 * @property serviceEndpoint Gets the service endpoint.
 * @property siteAppliancePropertiesCollection Gets or sets the appliance details used by service to communicate
 * to the appliance.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetWebAppSitesControllerResult(
    public val discoveryScenario: String? = null,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val serviceEndpoint: String,
    public val siteAppliancePropertiesCollection: List<SiteAppliancePropertiesResponse>? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.offazure.outputs.GetWebAppSitesControllerResult):
            GetWebAppSitesControllerResult = GetWebAppSitesControllerResult(
            discoveryScenario = javaType.discoveryScenario().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            serviceEndpoint = javaType.serviceEndpoint(),
            siteAppliancePropertiesCollection = javaType.siteAppliancePropertiesCollection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.offazure.kotlin.outputs.SiteAppliancePropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
