@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The properties of ServerSiteResource.
 * @property affectedObjectsCount Gets or sets the count of affected objects.
 * @property affectedResourceType Gets the affected resource type.
 * @property affectedResources Gets or sets the affected resources.
 * @property applianceName Gets the appliance name.
 * @property errorCode Gets the error code.
 * @property errorId Gets the error Id.
 * @property errorMessage Gets the error message.
 * @property fabricLayoutUpdateSources Gets or sets sources of the exception.
 * @property hitCount Gets or sets the hit count of the error.
 * @property remediationGuidance Gets the remediation guidance.
 * @property severity Gets the severity of error.
 * @property summaryMessage Gets the summary message.
 */
public data class SiteHealthSummaryResponse(
    public val affectedObjectsCount: Double? = null,
    public val affectedResourceType: String,
    public val affectedResources: List<String>? = null,
    public val applianceName: String,
    public val errorCode: String,
    public val errorId: Double,
    public val errorMessage: String,
    public val fabricLayoutUpdateSources: List<String>? = null,
    public val hitCount: Double? = null,
    public val remediationGuidance: String,
    public val severity: String,
    public val summaryMessage: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.offazure.outputs.SiteHealthSummaryResponse):
            SiteHealthSummaryResponse = SiteHealthSummaryResponse(
            affectedObjectsCount = javaType.affectedObjectsCount().map({ args0 -> args0 }).orElse(null),
            affectedResourceType = javaType.affectedResourceType(),
            affectedResources = javaType.affectedResources().map({ args0 -> args0 }),
            applianceName = javaType.applianceName(),
            errorCode = javaType.errorCode(),
            errorId = javaType.errorId(),
            errorMessage = javaType.errorMessage(),
            fabricLayoutUpdateSources = javaType.fabricLayoutUpdateSources().map({ args0 -> args0 }),
            hitCount = javaType.hitCount().map({ args0 -> args0 }).orElse(null),
            remediationGuidance = javaType.remediationGuidance(),
            severity = javaType.severity(),
            summaryMessage = javaType.summaryMessage(),
        )
    }
}
