@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazurespringboot.kotlin

import com.pulumi.azurenative.offazurespringboot.kotlin.outputs.SpringbootserversPropertiesResponse
import com.pulumi.azurenative.offazurespringboot.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.offazurespringboot.kotlin.outputs.SpringbootserversPropertiesResponse.Companion.toKotlin as springbootserversPropertiesResponseToKotlin
import com.pulumi.azurenative.offazurespringboot.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Springbootserver].
 */
@PulumiTagMarker
public class SpringbootserverResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SpringbootserverArgs = SpringbootserverArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SpringbootserverArgsBuilder.() -> Unit) {
        val builder = SpringbootserverArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Springbootserver {
        val builtJavaResource =
            com.pulumi.azurenative.offazurespringboot.Springbootserver(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Springbootserver(builtJavaResource)
    }
}

/**
 * The springbootservers envelope resource definition.
 * Azure REST API version: 2023-01-01-preview.
 * ## Example Usage
 * ### springbootservers_CreateOrUpdate_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var springbootserver = new AzureNative.OffAzureSpringBoot.Springbootserver("springbootserver", new()
 *     {
 *         Properties = new AzureNative.OffAzureSpringBoot.Inputs.SpringbootserversPropertiesArgs
 *         {
 *             Errors = new() { },
 *             FqdnAndIpAddressList = new() { },
 *             MachineArmId = "fvfkiapbqsprnbzczdfmuryknrna",
 *             Port = 10,
 *             Server = "thhuxocfyqpeluqcgnypi",
 *             SpringBootApps = 17,
 *             TotalApps = 5,
 *         },
 *         ResourceGroupName = "rgspringbootservers",
 *         SiteName = "hlkrzldhyobavtabgpubtjbhlslnjmsvkthwcfboriwyxndacjypzbj",
 *         SpringbootserversName = "zkarbqnwnxeozvjrkpdqmgnwedwgtwcmmyqwaijkn",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazurespringboot/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazurespringboot.NewSpringbootserver(ctx, "springbootserver", &offazurespringboot.SpringbootserverArgs{
 * 			Properties: offazurespringboot.SpringbootserversPropertiesResponse{
 * 				Errors:               offazurespringboot.ErrorArray{},
 * 				FqdnAndIpAddressList: pulumi.StringArray{},
 * 				MachineArmId:         pulumi.String("fvfkiapbqsprnbzczdfmuryknrna"),
 * 				Port:                 pulumi.Int(10),
 * 				Server:               pulumi.String("thhuxocfyqpeluqcgnypi"),
 * 				SpringBootApps:       pulumi.Int(17),
 * 				TotalApps:            pulumi.Int(5),
 * 			},
 * 			ResourceGroupName:     pulumi.String("rgspringbootservers"),
 * 			SiteName:              pulumi.String("hlkrzldhyobavtabgpubtjbhlslnjmsvkthwcfboriwyxndacjypzbj"),
 * 			SpringbootserversName: pulumi.String("zkarbqnwnxeozvjrkpdqmgnwedwgtwcmmyqwaijkn"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazurespringboot.Springbootserver;
 * import com.pulumi.azurenative.offazurespringboot.SpringbootserverArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var springbootserver = new Springbootserver("springbootserver", SpringbootserverArgs.builder()
 *             .properties(Map.ofEntries(
 *                 Map.entry("errors", ),
 *                 Map.entry("fqdnAndIpAddressList", ),
 *                 Map.entry("machineArmId", "fvfkiapbqsprnbzczdfmuryknrna"),
 *                 Map.entry("port", 10),
 *                 Map.entry("server", "thhuxocfyqpeluqcgnypi"),
 *                 Map.entry("springBootApps", 17),
 *                 Map.entry("totalApps", 5)
 *             ))
 *             .resourceGroupName("rgspringbootservers")
 *             .siteName("hlkrzldhyobavtabgpubtjbhlslnjmsvkthwcfboriwyxndacjypzbj")
 *             .springbootserversName("zkarbqnwnxeozvjrkpdqmgnwedwgtwcmmyqwaijkn")
 *             .build());
 *     }
 * }
 * ```
 * ### springbootservers_CreateOrUpdate_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var springbootserver = new AzureNative.OffAzureSpringBoot.Springbootserver("springbootserver", new()
 *     {
 *         ResourceGroupName = "rgspringbootservers",
 *         SiteName = "hlkrzldhyobavtabgpubtjbhlslnjmsvkthwcfboriwyxndacjypzbj",
 *         SpringbootserversName = "zkarbqnwnxeozvjrkpdqmgnwedwgtwcmmyqwaijkn",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazurespringboot/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazurespringboot.NewSpringbootserver(ctx, "springbootserver", &offazurespringboot.SpringbootserverArgs{
 * 			ResourceGroupName:     pulumi.String("rgspringbootservers"),
 * 			SiteName:              pulumi.String("hlkrzldhyobavtabgpubtjbhlslnjmsvkthwcfboriwyxndacjypzbj"),
 * 			SpringbootserversName: pulumi.String("zkarbqnwnxeozvjrkpdqmgnwedwgtwcmmyqwaijkn"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazurespringboot.Springbootserver;
 * import com.pulumi.azurenative.offazurespringboot.SpringbootserverArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var springbootserver = new Springbootserver("springbootserver", SpringbootserverArgs.builder()
 *             .resourceGroupName("rgspringbootservers")
 *             .siteName("hlkrzldhyobavtabgpubtjbhlslnjmsvkthwcfboriwyxndacjypzbj")
 *             .springbootserversName("zkarbqnwnxeozvjrkpdqmgnwedwgtwcmmyqwaijkn")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazurespringboot:Springbootserver licrobomiqalwnrti /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/springbootservers/{springbootserversName}
 * ```
 */
public class Springbootserver internal constructor(
    override val javaResource: com.pulumi.azurenative.offazurespringboot.Springbootserver,
) : KotlinCustomResource(javaResource, SpringbootserverMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The springbootservers resource definition.
     */
    public val properties: Output<SpringbootserversPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                springbootserversPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SpringbootserverMapper : ResourceMapper<Springbootserver> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.offazurespringboot.Springbootserver::class == javaResource::class

    override fun map(javaResource: Resource): Springbootserver = Springbootserver(
        javaResource as
            com.pulumi.azurenative.offazurespringboot.Springbootserver,
    )
}

/**
 * @see [Springbootserver].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Springbootserver].
 */
public suspend fun springbootserver(
    name: String,
    block: suspend SpringbootserverResourceBuilder.() -> Unit,
): Springbootserver {
    val builder = SpringbootserverResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Springbootserver].
 * @param name The _unique_ name of the resulting resource.
 */
public fun springbootserver(name: String): Springbootserver {
    val builder = SpringbootserverResourceBuilder()
    builder.name(name)
    return builder.build()
}
