@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazurespringboot.kotlin.inputs

import com.pulumi.azurenative.offazurespringboot.inputs.GetSpringbootserverPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property siteName The springbootsites name.
 * @property springbootserversName The springbootservers name.
 */
public data class GetSpringbootserverPlainArgs(
    public val resourceGroupName: String,
    public val siteName: String,
    public val springbootserversName: String,
) : ConvertibleToJava<com.pulumi.azurenative.offazurespringboot.inputs.GetSpringbootserverPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.offazurespringboot.inputs.GetSpringbootserverPlainArgs =
        com.pulumi.azurenative.offazurespringboot.inputs.GetSpringbootserverPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .siteName(siteName.let({ args0 -> args0 }))
            .springbootserversName(springbootserversName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSpringbootserverPlainArgs].
 */
@PulumiTagMarker
public class GetSpringbootserverPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var siteName: String? = null

    private var springbootserversName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("omlapdktxaglakmm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The springbootsites name.
     */
    @JvmName("vdlattcihgnxavug")
    public suspend fun siteName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.siteName = mapped
    }

    /**
     * @param value The springbootservers name.
     */
    @JvmName("ugvxagikndncxcjt")
    public suspend fun springbootserversName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.springbootserversName = mapped
    }

    internal fun build(): GetSpringbootserverPlainArgs = GetSpringbootserverPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        siteName = siteName ?: throw PulumiNullFieldException("siteName"),
        springbootserversName = springbootserversName ?: throw
            PulumiNullFieldException("springbootserversName"),
    )
}
