@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.openenergyplatform.kotlin.inputs

import com.pulumi.azurenative.openenergyplatform.inputs.DataPartitionNamesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The list of Energy services resource's Data Partition Names.
 * @property name
 */
public data class DataPartitionNamesArgs(
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.openenergyplatform.inputs.DataPartitionNamesArgs> {
    override fun toJava(): com.pulumi.azurenative.openenergyplatform.inputs.DataPartitionNamesArgs =
        com.pulumi.azurenative.openenergyplatform.inputs.DataPartitionNamesArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataPartitionNamesArgs].
 */
@PulumiTagMarker
public class DataPartitionNamesArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("aeamklntduubutky")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("rsesfayabnnfmdcf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): DataPartitionNamesArgs = DataPartitionNamesArgs(
        name = name,
    )
}
