@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin

import com.pulumi.azurenative.operationalinsights.ClusterArgs.builder
import com.pulumi.azurenative.operationalinsights.kotlin.enums.BillingType
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.ClusterSkuArgs
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.ClusterSkuArgsBuilder
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.KeyVaultPropertiesArgs
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.KeyVaultPropertiesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The top level Log Analytics cluster resource container.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2020-10-01.
 * Other available API versions: 2019-08-01-preview, 2020-08-01, 2022-10-01.
 * ## Example Usage
 * ### ClustersCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.OperationalInsights.Cluster("cluster", new()
 *     {
 *         ClusterName = "oiautorest6685",
 *         Location = "australiasoutheast",
 *         ResourceGroupName = "oiautorest6685",
 *         Sku = new AzureNative.OperationalInsights.Inputs.ClusterSkuArgs
 *         {
 *             Capacity = 1000,
 *             Name = "CapacityReservation",
 *         },
 *         Tags =
 *         {
 *             { "tag1", "val1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/operationalinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := operationalinsights.NewCluster(ctx, "cluster", &operationalinsights.ClusterArgs{
 * 			ClusterName:       pulumi.String("oiautorest6685"),
 * 			Location:          pulumi.String("australiasoutheast"),
 * 			ResourceGroupName: pulumi.String("oiautorest6685"),
 * 			Sku: &operationalinsights.ClusterSkuArgs{
 * 				Capacity: pulumi.Float64(1000),
 * 				Name:     pulumi.String("CapacityReservation"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("val1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.operationalinsights.Cluster;
 * import com.pulumi.azurenative.operationalinsights.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("oiautorest6685")
 *             .location("australiasoutheast")
 *             .resourceGroupName("oiautorest6685")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 1000),
 *                 Map.entry("name", "CapacityReservation")
 *             ))
 *             .tags(Map.of("tag1", "val1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:operationalinsights:Cluster oiautorest6685 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/clusters/{clusterName}
 * ```
 * @property billingType The cluster's billing type.
 * @property clusterName The name of the Log Analytics cluster.
 * @property identity The identity of the resource.
 * @property isAvailabilityZonesEnabled Sets whether the cluster will support availability zones. This can be set as true only in regions where Azure Data Explorer support Availability Zones. This Property can not be modified after cluster creation. Default value is 'true' if region supports Availability Zones.
 * @property isDoubleEncryptionEnabled Configures whether cluster will use double encryption. This Property can not be modified after cluster creation. Default value is 'true'
 * @property keyVaultProperties The associated key properties.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku The sku properties.
 * @property tags Resource tags.
 */
public data class ClusterArgs(
    public val billingType: Output<Either<String, BillingType>>? = null,
    public val clusterName: Output<String>? = null,
    public val identity: Output<IdentityArgs>? = null,
    public val isAvailabilityZonesEnabled: Output<Boolean>? = null,
    public val isDoubleEncryptionEnabled: Output<Boolean>? = null,
    public val keyVaultProperties: Output<KeyVaultPropertiesArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<ClusterSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.operationalinsights.ClusterArgs> {
    override fun toJava(): com.pulumi.azurenative.operationalinsights.ClusterArgs =
        com.pulumi.azurenative.operationalinsights.ClusterArgs.builder()
            .billingType(
                billingType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .isAvailabilityZonesEnabled(isAvailabilityZonesEnabled?.applyValue({ args0 -> args0 }))
            .isDoubleEncryptionEnabled(isDoubleEncryptionEnabled?.applyValue({ args0 -> args0 }))
            .keyVaultProperties(
                keyVaultProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ClusterArgs].
 */
@PulumiTagMarker
public class ClusterArgsBuilder internal constructor() {
    private var billingType: Output<Either<String, BillingType>>? = null

    private var clusterName: Output<String>? = null

    private var identity: Output<IdentityArgs>? = null

    private var isAvailabilityZonesEnabled: Output<Boolean>? = null

    private var isDoubleEncryptionEnabled: Output<Boolean>? = null

    private var keyVaultProperties: Output<KeyVaultPropertiesArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<ClusterSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The cluster's billing type.
     */
    @JvmName("ofcsebucpmcnylgy")
    public suspend fun billingType(`value`: Output<Either<String, BillingType>>) {
        this.billingType = value
    }

    /**
     * @param value The name of the Log Analytics cluster.
     */
    @JvmName("mahkjruqrxurbokt")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value The identity of the resource.
     */
    @JvmName("vfrjkfwffqyfrkyq")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Sets whether the cluster will support availability zones. This can be set as true only in regions where Azure Data Explorer support Availability Zones. This Property can not be modified after cluster creation. Default value is 'true' if region supports Availability Zones.
     */
    @JvmName("ftdawffqpmiqjpyi")
    public suspend fun isAvailabilityZonesEnabled(`value`: Output<Boolean>) {
        this.isAvailabilityZonesEnabled = value
    }

    /**
     * @param value Configures whether cluster will use double encryption. This Property can not be modified after cluster creation. Default value is 'true'
     */
    @JvmName("etlnwdrbfjcaqehc")
    public suspend fun isDoubleEncryptionEnabled(`value`: Output<Boolean>) {
        this.isDoubleEncryptionEnabled = value
    }

    /**
     * @param value The associated key properties.
     */
    @JvmName("dpelditljhynukav")
    public suspend fun keyVaultProperties(`value`: Output<KeyVaultPropertiesArgs>) {
        this.keyVaultProperties = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("uynblsixnicnaaqf")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("unvfsykvdrrbrhib")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The sku properties.
     */
    @JvmName("fbrcrfacafekfios")
    public suspend fun sku(`value`: Output<ClusterSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("nteyajxaonqffkfc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The cluster's billing type.
     */
    @JvmName("gwgngxirrjcvfijf")
    public suspend fun billingType(`value`: Either<String, BillingType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.billingType = mapped
    }

    /**
     * @param value The cluster's billing type.
     */
    @JvmName("ayvramnpdyvafoyu")
    public fun billingType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BillingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.billingType = mapped
    }

    /**
     * @param value The cluster's billing type.
     */
    @JvmName("dctbjyvctenodbdq")
    public fun billingType(`value`: BillingType) {
        val toBeMapped = Either.ofRight<String, BillingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.billingType = mapped
    }

    /**
     * @param value The name of the Log Analytics cluster.
     */
    @JvmName("xlrgknlhusbpmfvj")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value The identity of the resource.
     */
    @JvmName("neobhsyxahocvldl")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the resource.
     */
    @JvmName("mprshlgemiulbsqr")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Sets whether the cluster will support availability zones. This can be set as true only in regions where Azure Data Explorer support Availability Zones. This Property can not be modified after cluster creation. Default value is 'true' if region supports Availability Zones.
     */
    @JvmName("nkdaavhujwhhijmb")
    public suspend fun isAvailabilityZonesEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isAvailabilityZonesEnabled = mapped
    }

    /**
     * @param value Configures whether cluster will use double encryption. This Property can not be modified after cluster creation. Default value is 'true'
     */
    @JvmName("hmdbidslgilglddq")
    public suspend fun isDoubleEncryptionEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isDoubleEncryptionEnabled = mapped
    }

    /**
     * @param value The associated key properties.
     */
    @JvmName("tjgqyswxwesawbor")
    public suspend fun keyVaultProperties(`value`: KeyVaultPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultProperties = mapped
    }

    /**
     * @param argument The associated key properties.
     */
    @JvmName("udvsixautnogvuks")
    public suspend
    fun keyVaultProperties(argument: suspend KeyVaultPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyVaultProperties = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("gkawpfqhhqpryfgn")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jmxfsexibmtowurg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The sku properties.
     */
    @JvmName("cvycarrslfpgvqub")
    public suspend fun sku(`value`: ClusterSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The sku properties.
     */
    @JvmName("cbiqbqixfrisnxie")
    public suspend fun sku(argument: suspend ClusterSkuArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("dbngrtyojwmdedey")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ueuauyaxprtlpvcx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ClusterArgs = ClusterArgs(
        billingType = billingType,
        clusterName = clusterName,
        identity = identity,
        isAvailabilityZonesEnabled = isAvailabilityZonesEnabled,
        isDoubleEncryptionEnabled = isDoubleEncryptionEnabled,
        keyVaultProperties = keyVaultProperties,
        location = location,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
