@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin

import com.pulumi.azurenative.operationalinsights.LinkedServiceArgs.builder
import com.pulumi.azurenative.operationalinsights.kotlin.enums.LinkedServiceEntityStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The top level Linked service resource container.
 * Azure REST API version: 2020-08-01. Prior API version in Azure Native 1.x: 2020-08-01.
 * Other available API versions: 2015-11-01-preview.
 * ## Example Usage
 * ### LinkedServicesCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var linkedService = new AzureNative.OperationalInsights.LinkedService("linkedService", new()
 *     {
 *         LinkedServiceName = "Cluster",
 *         ResourceGroupName = "mms-eus",
 *         WorkspaceName = "TestLinkWS",
 *         WriteAccessResourceId = "/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/mms-eus/providers/Microsoft.OperationalInsights/clusters/testcluster",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/operationalinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := operationalinsights.NewLinkedService(ctx, "linkedService", &operationalinsights.LinkedServiceArgs{
 * 			LinkedServiceName:     pulumi.String("Cluster"),
 * 			ResourceGroupName:     pulumi.String("mms-eus"),
 * 			WorkspaceName:         pulumi.String("TestLinkWS"),
 * 			WriteAccessResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/mms-eus/providers/Microsoft.OperationalInsights/clusters/testcluster"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.operationalinsights.LinkedService;
 * import com.pulumi.azurenative.operationalinsights.LinkedServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var linkedService = new LinkedService("linkedService", LinkedServiceArgs.builder()
 *             .linkedServiceName("Cluster")
 *             .resourceGroupName("mms-eus")
 *             .workspaceName("TestLinkWS")
 *             .writeAccessResourceId("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/mms-eus/providers/Microsoft.OperationalInsights/clusters/testcluster")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:operationalinsights:LinkedService TestLinkWS/Cluster /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/linkedServices/{linkedServiceName}
 * ```
 * @property linkedServiceName Name of the linkedServices resource
 * @property provisioningState The provisioning state of the linked service.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceId The resource id of the resource that will be linked to the workspace. This should be used for linking resources which require read access
 * @property tags Resource tags.
 * @property workspaceName The name of the workspace.
 * @property writeAccessResourceId The resource id of the resource that will be linked to the workspace. This should be used for linking resources which require write access
 */
public data class LinkedServiceArgs(
    public val linkedServiceName: Output<String>? = null,
    public val provisioningState: Output<Either<String, LinkedServiceEntityStatus>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workspaceName: Output<String>? = null,
    public val writeAccessResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.operationalinsights.LinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.operationalinsights.LinkedServiceArgs =
        com.pulumi.azurenative.operationalinsights.LinkedServiceArgs.builder()
            .linkedServiceName(linkedServiceName?.applyValue({ args0 -> args0 }))
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 }))
            .writeAccessResourceId(writeAccessResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LinkedServiceArgs].
 */
@PulumiTagMarker
public class LinkedServiceArgsBuilder internal constructor() {
    private var linkedServiceName: Output<String>? = null

    private var provisioningState: Output<Either<String, LinkedServiceEntityStatus>>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workspaceName: Output<String>? = null

    private var writeAccessResourceId: Output<String>? = null

    /**
     * @param value Name of the linkedServices resource
     */
    @JvmName("ecsgyjibcuqunotx")
    public suspend fun linkedServiceName(`value`: Output<String>) {
        this.linkedServiceName = value
    }

    /**
     * @param value The provisioning state of the linked service.
     */
    @JvmName("hpnqdynmbohqijxy")
    public suspend fun provisioningState(`value`: Output<Either<String, LinkedServiceEntityStatus>>) {
        this.provisioningState = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qeamecbmdpcmlsgu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The resource id of the resource that will be linked to the workspace. This should be used for linking resources which require read access
     */
    @JvmName("nwrrlnheytyjidmk")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xiavwjxqocfuogqk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("hfnhhfelihhnyikk")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The resource id of the resource that will be linked to the workspace. This should be used for linking resources which require write access
     */
    @JvmName("nalahnvjvxxgapvg")
    public suspend fun writeAccessResourceId(`value`: Output<String>) {
        this.writeAccessResourceId = value
    }

    /**
     * @param value Name of the linkedServices resource
     */
    @JvmName("ajlkvaknhgmxjpkn")
    public suspend fun linkedServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param value The provisioning state of the linked service.
     */
    @JvmName("tbyrsuhnywgortlo")
    public suspend fun provisioningState(`value`: Either<String, LinkedServiceEntityStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The provisioning state of the linked service.
     */
    @JvmName("hftctdkxebudrwgj")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LinkedServiceEntityStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The provisioning state of the linked service.
     */
    @JvmName("iwipehptftvgtyxp")
    public fun provisioningState(`value`: LinkedServiceEntityStatus) {
        val toBeMapped = Either.ofRight<String, LinkedServiceEntityStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hoxcntsdcxknwaam")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource id of the resource that will be linked to the workspace. This should be used for linking resources which require read access
     */
    @JvmName("jprtgcrdcsggvapa")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wrlpauaqjerpbbge")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("sovedyyxkdlmqcdf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("wixdwenopdwhyqfn")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    /**
     * @param value The resource id of the resource that will be linked to the workspace. This should be used for linking resources which require write access
     */
    @JvmName("nkexjgcnfeluwqte")
    public suspend fun writeAccessResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeAccessResourceId = mapped
    }

    internal fun build(): LinkedServiceArgs = LinkedServiceArgs(
        linkedServiceName = linkedServiceName,
        provisioningState = provisioningState,
        resourceGroupName = resourceGroupName,
        resourceId = resourceId,
        tags = tags,
        workspaceName = workspaceName,
        writeAccessResourceId = writeAccessResourceId,
    )
}
